package com.xforceplus.phoenix.casm.model;

import com.xforceplus.phoenix.casm.model.invoiceinfo.InvoiceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("抬头信息新增请求")
public class CreateHeaderRequest {

    @ApiModelProperty("客商类型")
    private String partnerType;

    @ApiModelProperty("企业名称")
    private String companyName;

    @ApiModelProperty("企业税号")
    private String companyTaxNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("客商标签")
    private String partnerLabel;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("客商编号列表")
    private List<PartnerInfo> partners;

    @ApiModelProperty("票面信息")
    private List<InvoiceInfo> invoiceInfos;

    //预留扩展字段
    @ApiModelProperty("扩展字段1")
    private String ext1;
    @ApiModelProperty("扩展字段2")
    private String ext2;
    @ApiModelProperty("扩展字段3")
    private String ext3;
    @ApiModelProperty("扩展字段4")
    private String ext4;
    @ApiModelProperty("扩展字段5")
    private String ext5;
    @ApiModelProperty("扩展字段6")
    private String ext6;
    @ApiModelProperty("扩展字段7")
    private String ext7;
    @ApiModelProperty("扩展字段8")
    private String ext8;
    @ApiModelProperty("扩展字段9")
    private String ext9;
    @ApiModelProperty("扩展字段10")
    private String ext10;
    @ApiModelProperty("扩展字段11")
    private String ext11;
    @ApiModelProperty("扩展字段12")
    private String ext12;

    @ApiModelProperty("手机号")
    private String mobileNumber;

    //不可开票标记：枚举值：1-是、0-否；
    @ApiModelProperty("开票标志")
    private String invoiceFlag = "0";

    //1-覆盖
    @ApiModelProperty("覆盖标志")
    private String overwrite = "0";
}
