package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 批量新增返回对象
 */
@ApiModel(description = "批量新增返回对象")

@JsonInclude(NON_NULL)
public class MsBatchMain {
  @JsonProperty("casMainSuccessNums")
  private Integer casMainSuccessNums = null;

  @JsonProperty("casMainFailNums")
  private Integer casMainFailNums = null;

  @JsonProperty("casInvoiceSuccessNums")
  private Integer casInvoiceSuccessNums = null;

  @JsonProperty("casInvoiceFailNums")
  private Integer casInvoiceFailNums = null;

  @JsonIgnore
  public MsBatchMain casMainSuccessNums(Integer casMainSuccessNums) {
    this.casMainSuccessNums = casMainSuccessNums;
    return this;
  }

   /**
   * 客商主信息成功数量
   * @return casMainSuccessNums
  **/
  @ApiModelProperty(value = "客商主信息成功数量")
  public Integer getCasMainSuccessNums() {
    return casMainSuccessNums;
  }

  public void setCasMainSuccessNums(Integer casMainSuccessNums) {
    this.casMainSuccessNums = casMainSuccessNums;
  }

  @JsonIgnore
  public MsBatchMain casMainFailNums(Integer casMainFailNums) {
    this.casMainFailNums = casMainFailNums;
    return this;
  }

   /**
   * 客商主信息失败数量
   * @return casMainFailNums
  **/
  @ApiModelProperty(value = "客商主信息失败数量")
  public Integer getCasMainFailNums() {
    return casMainFailNums;
  }

  public void setCasMainFailNums(Integer casMainFailNums) {
    this.casMainFailNums = casMainFailNums;
  }

  @JsonIgnore
  public MsBatchMain casInvoiceSuccessNums(Integer casInvoiceSuccessNums) {
    this.casInvoiceSuccessNums = casInvoiceSuccessNums;
    return this;
  }

   /**
   * 客商票面信息成功数量
   * @return casInvoiceSuccessNums
  **/
  @ApiModelProperty(value = "客商票面信息成功数量")
  public Integer getCasInvoiceSuccessNums() {
    return casInvoiceSuccessNums;
  }

  public void setCasInvoiceSuccessNums(Integer casInvoiceSuccessNums) {
    this.casInvoiceSuccessNums = casInvoiceSuccessNums;
  }

  @JsonIgnore
  public MsBatchMain casInvoiceFailNums(Integer casInvoiceFailNums) {
    this.casInvoiceFailNums = casInvoiceFailNums;
    return this;
  }

   /**
   * 客商票面信息失败数量
   * @return casInvoiceFailNums
  **/
  @ApiModelProperty(value = "客商票面信息失败数量")
  public Integer getCasInvoiceFailNums() {
    return casInvoiceFailNums;
  }

  public void setCasInvoiceFailNums(Integer casInvoiceFailNums) {
    this.casInvoiceFailNums = casInvoiceFailNums;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBatchMain batchMain = (MsBatchMain) o;
    return Objects.equals(this.casMainSuccessNums, batchMain.casMainSuccessNums) &&
        Objects.equals(this.casMainFailNums, batchMain.casMainFailNums) &&
        Objects.equals(this.casInvoiceSuccessNums, batchMain.casInvoiceSuccessNums) &&
        Objects.equals(this.casInvoiceFailNums, batchMain.casInvoiceFailNums);
  }

  @Override
  public int hashCode() {
    return Objects.hash(casMainSuccessNums, casMainFailNums, casInvoiceSuccessNums, casInvoiceFailNums);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBatchMain {\n");
    
    sb.append("    casMainSuccessNums: ").append(toIndentedString(casMainSuccessNums)).append("\n");
    sb.append("    casMainFailNums: ").append(toIndentedString(casMainFailNums)).append("\n");
    sb.append("    casInvoiceSuccessNums: ").append(toIndentedString(casInvoiceSuccessNums)).append("\n");
    sb.append("    casInvoiceFailNums: ").append(toIndentedString(casInvoiceFailNums)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
