package com.xforceplus.phoenix.casm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.phoenix.casm.model.invoiceinfo.MsCasInvoiceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 客商明细信息
 */
@ApiModel(description = "客商明细信息")

@JsonInclude(NON_NULL)
public class MsCasDetails {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("casType")
  private Integer casType = null;

  @JsonProperty("casClassify")
  private String casClassify = null;

  @JsonProperty("enterpriseName")
  private String enterpriseName = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceFlag")
  private String invoiceFlag = "0";

  @JsonProperty("casLabel")
  private String casLabel = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("personIdCard")
  private String personIdCard = null;

  @JsonProperty("CasTaxNo")
  private String casTaxNo = null;

  @JsonProperty("directorId")
  private Long directorId = null;

  @JsonProperty("directorName")
  private String directorName = null;

  @JsonProperty("participants")
  private String participants = null;

  @JsonProperty("mobileNumber")
  private String mobileNumber = null;

  @JsonProperty("CasTaxNos")
  private List<MsCasTaxNo> casTaxNos = new ArrayList<MsCasTaxNo>();

  @JsonProperty("CasIdentifierNos")
  private List<MsCasIdentifierNo> casIdentifierNos = new ArrayList<MsCasIdentifierNo>();

  @JsonProperty("CasInvoiceInfos")
  private List<MsCasInvoiceInfo> casInvoiceInfos = new ArrayList<MsCasInvoiceInfo>();

  @JsonIgnore
  public MsCasDetails id(Long id) {
    this.id = id;
    return this;
  }

  @JsonIgnore
  public MsCasDetails invoiceFlag(String invoiceFlag) {
    this.invoiceFlag = invoiceFlag;
    return this;
  }

  public String getInvoiceFlag() {
    return invoiceFlag;
  }

  public void setInvoiceFlag(String invoiceFlag) {
    this.invoiceFlag = invoiceFlag;
  }

  public String getPersonIdCard() {
    return personIdCard;
  }

  public void setPersonIdCard(String personIdCard) {
    this.personIdCard = personIdCard;
  }

  /**
   * 客商id
   * @return id
  **/
  @ApiModelProperty(value = "客商id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCasDetails groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsCasDetails casType(Integer casType) {
    this.casType = casType;
    return this;
  }

   /**
   * 客商类型:1-客户2-供应商3-客户和供应商
   * @return casType
  **/
  @ApiModelProperty(value = "客商类型:1-客户2-供应商3-客户和供应商")
  public Integer getCasType() {
    return casType;
  }

  public void setCasType(Integer casType) {
    this.casType = casType;
  }

  @JsonIgnore
  public MsCasDetails casClassify(String casClassify) {
    this.casClassify = casClassify;
    return this;
  }

   /**
   * 客商分类(用户自定义)
   * @return casClassify
  **/
  @ApiModelProperty(value = "客商分类(用户自定义)")
  public String getCasClassify() {
    return casClassify;
  }

  public void setCasClassify(String casClassify) {
    this.casClassify = casClassify;
  }

  @JsonIgnore
  public MsCasDetails enterpriseName(String enterpriseName) {
    this.enterpriseName = enterpriseName;
    return this;
  }

   /**
   * 企业名称
   * @return enterpriseName
  **/
  @ApiModelProperty(value = "企业名称")
  public String getEnterpriseName() {
    return enterpriseName;
  }

  public void setEnterpriseName(String enterpriseName) {
    this.enterpriseName = enterpriseName;
  }

  @JsonIgnore
  public MsCasDetails remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }



  @JsonIgnore
  public MsCasDetails invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  /**
   * 发票类型
   * @return invoiceType
   **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }


  @JsonIgnore
  public MsCasDetails casLabel(String casLabel) {
    this.casLabel = casLabel;
    return this;
  }

   /**
   * 标签
   * @return casLabel
  **/
  @ApiModelProperty(value = "标签")
  public String getCasLabel() {
    return casLabel;
  }

  public void setCasLabel(String casLabel) {
    this.casLabel = casLabel;
  }

  @JsonIgnore
  public MsCasDetails email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 邮箱
   * @return email
  **/
  @ApiModelProperty(value = "邮箱")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsCasDetails casTaxNo(String casTaxNo) {
    this.casTaxNo = casTaxNo;
    return this;
  }

   /**
   * 客商税号（最新）
   * @return casTaxNo
  **/
  @ApiModelProperty(value = "客商税号（最新）")
  public String getCasTaxNo() {
    return casTaxNo;
  }

  public void setCasTaxNo(String casTaxNo) {
    this.casTaxNo = casTaxNo;
  }

  @JsonIgnore
  public MsCasDetails directorId(Long directorId) {
    this.directorId = directorId;
    return this;
  }

   /**
   * 负责人id
   * @return directorId
  **/
  @ApiModelProperty(value = "负责人id")
  public Long getDirectorId() {
    return directorId;
  }

  public void setDirectorId(Long directorId) {
    this.directorId = directorId;
  }

  @JsonIgnore
  public MsCasDetails directorName(String directorName) {
    this.directorName = directorName;
    return this;
  }

   /**
   * 负责人姓名
   * @return directorName
  **/
  @ApiModelProperty(value = "负责人姓名")
  public String getDirectorName() {
    return directorName;
  }

  public void setDirectorName(String directorName) {
    this.directorName = directorName;
  }

  @JsonIgnore
  public MsCasDetails participants(String participants) {
    this.participants = participants;
    return this;
  }
  @JsonIgnore
  public MsCasDetails mobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
    return this;
  }
  @ApiModelProperty(value = "手机号")
  public String getMobileNumber() {
    return mobileNumber;
  }

  public void setMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
  }

  /**
   * 参与者id(多个id以英文状态下,分割)
   * @return participants
  **/
  @ApiModelProperty(value = "参与者id(多个id以英文状态下,分割)")
  public String getParticipants() {
    return participants;
  }

  public void setParticipants(String participants) {
    this.participants = participants;
  }

  @JsonIgnore
  public MsCasDetails casTaxNos(List<MsCasTaxNo> casTaxNos) {
    this.casTaxNos = casTaxNos;
    return this;
  }

  public MsCasDetails addCasTaxNosItem(MsCasTaxNo casTaxNosItem) {
    this.casTaxNos.add(casTaxNosItem);
    return this;
  }

   /**
   * 客商税号信息
   * @return casTaxNos
  **/
  @ApiModelProperty(value = "客商税号信息")
  public List<MsCasTaxNo> getCasTaxNos() {
    return casTaxNos;
  }

  public void setCasTaxNos(List<MsCasTaxNo> casTaxNos) {
    this.casTaxNos = casTaxNos;
  }

  @JsonIgnore
  public MsCasDetails casIdentifierNos(List<MsCasIdentifierNo> casIdentifierNos) {
    this.casIdentifierNos = casIdentifierNos;
    return this;
  }

  public MsCasDetails addCasIdentifierNosItem(MsCasIdentifierNo casIdentifierNosItem) {
    this.casIdentifierNos.add(casIdentifierNosItem);
    return this;
  }

   /**
   * 客商编号信息
   * @return casIdentifierNos
  **/
  @ApiModelProperty(value = "客商编号信息")
  public List<MsCasIdentifierNo> getCasIdentifierNos() {
    return casIdentifierNos;
  }

  public void setCasIdentifierNos(List<MsCasIdentifierNo> casIdentifierNos) {
    this.casIdentifierNos = casIdentifierNos;
  }

  @JsonIgnore
  public MsCasDetails casInvoiceInfos(List<MsCasInvoiceInfo> casInvoiceInfos) {
    this.casInvoiceInfos = casInvoiceInfos;
    return this;
  }

  public MsCasDetails addCasInvoiceInfosItem(MsCasInvoiceInfo casInvoiceInfosItem) {
    this.casInvoiceInfos.add(casInvoiceInfosItem);
    return this;
  }

   /**
   * 客商票面信息
   * @return casInvoiceInfos
  **/
  @ApiModelProperty(value = "客商票面信息")
  public List<MsCasInvoiceInfo> getCasInvoiceInfos() {
    return casInvoiceInfos;
  }

  public void setCasInvoiceInfos(List<MsCasInvoiceInfo> casInvoiceInfos) {
    this.casInvoiceInfos = casInvoiceInfos;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCasDetails casDetails = (MsCasDetails) o;
    return Objects.equals(this.id, casDetails.id) &&
        Objects.equals(this.groupid, casDetails.groupid) &&
        Objects.equals(this.casType, casDetails.casType) &&
        Objects.equals(this.casClassify, casDetails.casClassify) &&
        Objects.equals(this.enterpriseName, casDetails.enterpriseName) &&
        Objects.equals(this.remark, casDetails.remark) &&
        Objects.equals(this.invoiceType, casDetails.invoiceType) &&
        Objects.equals(this.invoiceFlag, casDetails.invoiceFlag) &&
        Objects.equals(this.casLabel, casDetails.casLabel) &&
        Objects.equals(this.email, casDetails.email) &&
        Objects.equals(this.casTaxNo, casDetails.casTaxNo) &&
        Objects.equals(this.directorId, casDetails.directorId) &&
        Objects.equals(this.directorName, casDetails.directorName) &&
        Objects.equals(this.participants, casDetails.participants) &&
        Objects.equals(this.casTaxNos, casDetails.casTaxNos) &&
        Objects.equals(this.casIdentifierNos, casDetails.casIdentifierNos) &&
        Objects.equals(this.casInvoiceInfos, casDetails.casInvoiceInfos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupid, casType, casClassify, enterpriseName, remark, invoiceType, invoiceFlag, casLabel, email, casTaxNo, directorId, directorName, participants, casTaxNos, casIdentifierNos, casInvoiceInfos);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCasDetails {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    casType: ").append(toIndentedString(casType)).append("\n");
    sb.append("    casClassify: ").append(toIndentedString(casClassify)).append("\n");
    sb.append("    enterpriseName: ").append(toIndentedString(enterpriseName)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceFlag: ").append(toIndentedString(invoiceFlag)).append("\n");
    sb.append("    casLabel: ").append(toIndentedString(casLabel)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    casTaxNo: ").append(toIndentedString(casTaxNo)).append("\n");
    sb.append("    directorId: ").append(toIndentedString(directorId)).append("\n");
    sb.append("    directorName: ").append(toIndentedString(directorName)).append("\n");
    sb.append("    participants: ").append(toIndentedString(participants)).append("\n");
    sb.append("    casTaxNos: ").append(toIndentedString(casTaxNos)).append("\n");
    sb.append("    casIdentifierNos: ").append(toIndentedString(casIdentifierNos)).append("\n");
    sb.append("    casInvoiceInfos: ").append(toIndentedString(casInvoiceInfos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
