package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;

import javax.validation.constraints.*;

/**
 * 客商编号
 */
@ApiModel(description = "客商编号")

@JsonInclude(NON_NULL)
public class MsCasIdentifierNo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("identifierNo")
  private String identifierNo = null;

  @JsonProperty("identifierName")
  private String identifierName = null;

  @JsonProperty("bankName")
  private String bankName = null;
  @JsonProperty("bankAccount")
  private String bankAccount = null;
  @JsonProperty("address")
  private String address = null;
  @JsonProperty("tel")
  private String tel = null;
  @JsonProperty("email")
  private String email = null;

  @JsonProperty("mobileNumber")
  private String mobileNumber = null;

  //预留扩展字段

  @Getter
  private String ext1;

  @Getter
  private String ext2;

  @Getter
  private String ext3;

  @Getter
  private String ext4;

  @Getter
  private String ext5;

  @Getter
  private String ext6;

  @Getter
  private String ext7;


  @Getter
  private String ext8;

  @Getter
  private String ext9;

  @Getter
  private String ext10;


  @Getter
  private String ext11;

  @Getter
  private String ext12;

  public String getMobileNumber() {
    return mobileNumber;
  }

  public void setMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
  }

  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  public String getBankAccount() {
    return bankAccount;
  }

  public void setBankAccount(String bankAccount) {
    this.bankAccount = bankAccount;
  }

  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public String getTel() {
    return tel;
  }

  public void setTel(String tel) {
    this.tel = tel;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsCasIdentifierNo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 接口表主键
   * @return id
  **/
  @ApiModelProperty(value = "接口表主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCasIdentifierNo identifierNo(String identifierNo) {
    this.identifierNo = identifierNo;
    return this;
  }

  public String getIdentifierName() {
    return identifierName;
  }

  public void setIdentifierName(String identifierName) {
    this.identifierName = identifierName;
  }

  /**
   * 客商编号
   * @return identifierNo
  **/
  @ApiModelProperty(value = "客商编号")
  public String getIdentifierNo() {
    return identifierNo;
  }

  public void setIdentifierNo(String identifierNo) {
    this.identifierNo = identifierNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCasIdentifierNo casIdentifierNo = (MsCasIdentifierNo) o;
    return Objects.equals(this.id, casIdentifierNo.id) &&
        Objects.equals(this.identifierNo, casIdentifierNo.identifierNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, identifierNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCasIdentifierNo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    identifierNo: ").append(toIndentedString(identifierNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }

  public void setExt3(String ext3) {
    this.ext3 = ext3;
  }

  public void setExt4(String ext4) {
    this.ext4 = ext4;
  }

  public void setExt5(String ext5) {
    this.ext5 = ext5;
  }

  public void setExt6(String ext6) {
    this.ext6 = ext6;
  }

  public void setExt7(String ext7) {
    this.ext7 = ext7;
  }

  public void setExt8(String ext8) {
    this.ext8 = ext8;
  }

  public void setExt9(String ext9) {
    this.ext9 = ext9;
  }

  public void setExt10(String ext10) {
    this.ext10 = ext10;
  }

  public void setExt11(String ext11) {
    this.ext11 = ext11;
  }

  public void setExt12(String ext12) {
    this.ext12 = ext12;
  }

}
