package com.xforceplus.phoenix.casm.model;

import java.util.List;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询客商主信息请求返回
 */
@ApiModel(description = "查询客商主信息请求返回")

@JsonInclude(NON_NULL)
public class MsCasMsg {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("casType")
  private Integer casType = null;

  @JsonProperty("casClassify")
  private String casClassify = null;

  @JsonProperty("enterpriseName")
  private String enterpriseName = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("CasTaxNo")
  private String casTaxNo = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("personIdCard")
  private String personIdCard = null;
  @JsonProperty("mobileNumber")
  private String mobileNumber = null;

  @JsonProperty("identifierNos")
  private List<MsCasIdentifierNo> identifierNos;

  public List<MsCasIdentifierNo> getIdentifierNos() {
    return identifierNos;
  }

  public void setIdentifierNos(List<MsCasIdentifierNo> identifierNos) {
    this.identifierNos = identifierNos;
  }

  public String getPersonIdCard() {
    return personIdCard;
  }

  public void setPersonIdCard(String personIdCard) {
    this.personIdCard = personIdCard;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }


  @JsonIgnore
  public MsCasMsg id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 客商id
   * @return id
  **/
  @ApiModelProperty(value = "客商id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCasMsg groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsCasMsg casType(Integer casType) {
    this.casType = casType;
    return this;
  }

   /**
   * 客商类型:1-客户2-供应商3-客户和供应商
   * @return casType
  **/
  @ApiModelProperty(value = "客商类型:1-客户2-供应商3-客户和供应商")
  public Integer getCasType() {
    return casType;
  }

  public void setCasType(Integer casType) {
    this.casType = casType;
  }

  @JsonIgnore
  public MsCasMsg casClassify(String casClassify) {
    this.casClassify = casClassify;
    return this;
  }

   /**
   * 客商分类(用户自定义)
   * @return casClassify
  **/
  @ApiModelProperty(value = "客商分类(用户自定义)")
  public String getCasClassify() {
    return casClassify;
  }

  public void setCasClassify(String casClassify) {
    this.casClassify = casClassify;
  }

  @JsonIgnore
  public MsCasMsg enterpriseName(String enterpriseName) {
    this.enterpriseName = enterpriseName;
    return this;
  }

   /**
   * 企业名称
   * @return enterpriseName
  **/
  @ApiModelProperty(value = "企业名称")
  public String getEnterpriseName() {
    return enterpriseName;
  }

  public void setEnterpriseName(String enterpriseName) {
    this.enterpriseName = enterpriseName;
  }

  @JsonIgnore
  public MsCasMsg remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }




  @JsonIgnore
  public MsCasMsg invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  /**
   * 发票类型
   * @return invoiceType
   **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }



  @JsonIgnore
  public MsCasMsg casTaxNo(String casTaxNo) {
    this.casTaxNo = casTaxNo;
    return this;
  }

   /**
   * 客商税号
   * @return casTaxNo
  **/
  @ApiModelProperty(value = "客商税号")
  public String getCasTaxNo() {
    return casTaxNo;
  }

  public void setCasTaxNo(String casTaxNo) {
    this.casTaxNo = casTaxNo;
  }

  @JsonIgnore
  public MsCasMsg createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsCasMsg updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 修改时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "修改时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCasMsg casMsg = (MsCasMsg) o;
    return Objects.equals(this.id, casMsg.id) &&
        Objects.equals(this.groupid, casMsg.groupid) &&
        Objects.equals(this.casType, casMsg.casType) &&
        Objects.equals(this.casClassify, casMsg.casClassify) &&
        Objects.equals(this.enterpriseName, casMsg.enterpriseName) &&
        Objects.equals(this.remark, casMsg.remark) &&
        Objects.equals(this.invoiceType, casMsg.invoiceType) &&
        Objects.equals(this.casTaxNo, casMsg.casTaxNo) &&
        Objects.equals(this.createUserName, casMsg.createUserName) &&
        Objects.equals(this.updateTime, casMsg.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupid, casType, casClassify, enterpriseName, remark, invoiceType, casTaxNo, createUserName, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCasMsg {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    casType: ").append(toIndentedString(casType)).append("\n");
    sb.append("    casClassify: ").append(toIndentedString(casClassify)).append("\n");
    sb.append("    enterpriseName: ").append(toIndentedString(enterpriseName)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    casTaxNo: ").append(toIndentedString(casTaxNo)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  @JsonIgnore
  public MsCasMsg mobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
    return this;
  }

  @ApiModelProperty(value = "手机号")
  public String getMobileNumber() {
    return mobileNumber;
  }

  public void setMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
  }
}
