package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 客商税号
 */
@ApiModel(description = "客商税号")

@JsonInclude(NON_NULL)
public class MsCasTaxNo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("newFlag")
  private Integer newFlag = null;

  @JsonIgnore
  public MsCasTaxNo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 接口表主键
   * @return id
  **/
  @ApiModelProperty(value = "接口表主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCasTaxNo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 企业税号(最新)
   * @return taxNo
  **/
  @ApiModelProperty(value = "企业税号(最新)")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public MsCasTaxNo newFlag(Integer newFlag) {
    this.newFlag = newFlag;
    return this;
  }

   /**
   * 最新税号标识1最新税号0旧税号
   * @return newFlag
  **/
  @ApiModelProperty(value = "最新税号标识1最新税号0旧税号")
  public Integer getNewFlag() {
    return newFlag;
  }

  public void setNewFlag(Integer newFlag) {
    this.newFlag = newFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCasTaxNo casTaxNo = (MsCasTaxNo) o;
    return Objects.equals(this.id, casTaxNo.id) &&
        Objects.equals(this.taxNo, casTaxNo.taxNo) &&
        Objects.equals(this.newFlag, casTaxNo.newFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, taxNo, newFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCasTaxNo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    newFlag: ").append(toIndentedString(newFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
