package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 删除客商税号、编号、票面信息请求
 */
@ApiModel(description = "删除客商税号、编号、票面信息请求")

@JsonInclude(NON_NULL)
public class MsDelCasSubInfoRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonProperty("operatorName")
  private String operatorName = null;

  @JsonIgnore
  public MsDelCasSubInfoRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键id-税号\\编号\\票面信息id
   * @return id
  **/
  @ApiModelProperty(value = "主键id-税号\\编号\\票面信息id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsDelCasSubInfoRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsDelCasSubInfoRequest operatorName(String operatorName) {
    this.operatorName = operatorName;
    return this;
  }

   /**
   * 操作者姓名
   * @return operatorName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getOperatorName() {
    return operatorName;
  }

  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDelCasSubInfoRequest delCasSubInfoRequest = (MsDelCasSubInfoRequest) o;
    return Objects.equals(this.id, delCasSubInfoRequest.id) &&
        Objects.equals(this.operatorId, delCasSubInfoRequest.operatorId) &&
        Objects.equals(this.operatorName, delCasSubInfoRequest.operatorName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, operatorId, operatorName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDelCasSubInfoRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    operatorName: ").append(toIndentedString(operatorName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
