package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 模板下载信息
 */
@ApiModel(description = "模板下载信息")

@JsonInclude(NON_NULL)
public class MsExportTemplateModel {
  @JsonProperty("key")
  private String key = null;

  @JsonProperty("fileDisplayName")
  private String fileDisplayName = null;

  @JsonIgnore
  public MsExportTemplateModel key(String key) {
    this.key = key;
    return this;
  }

   /**
   * 文件key
   * @return key
  **/
  @ApiModelProperty(value = "文件key")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @JsonIgnore
  public MsExportTemplateModel fileDisplayName(String fileDisplayName) {
    this.fileDisplayName = fileDisplayName;
    return this;
  }

   /**
   * 文件指定名
   * @return fileDisplayName
  **/
  @ApiModelProperty(value = "文件指定名")
  public String getFileDisplayName() {
    return fileDisplayName;
  }

  public void setFileDisplayName(String fileDisplayName) {
    this.fileDisplayName = fileDisplayName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsExportTemplateModel exportTemplateModel = (MsExportTemplateModel) o;
    return Objects.equals(this.key, exportTemplateModel.key) &&
        Objects.equals(this.fileDisplayName, exportTemplateModel.fileDisplayName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, fileDisplayName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsExportTemplateModel {\n");
    
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    fileDisplayName: ").append(toIndentedString(fileDisplayName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
