package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 导入客商信息请求
 */
@ApiModel(description = "导入客商信息请求")

@JsonInclude(NON_NULL)
public class MsImportCasRequest {
  @JsonProperty("ossKey")
  private String ossKey = null;

  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonProperty("operatorName")
  private String operatorName = null;
  @JsonProperty("link")
  private String link = null;

  public String getLink() {
    return link;
  }

  public void setLink(String link) {
    this.link = link;
  }

  @JsonIgnore
  public MsImportCasRequest ossKey(String ossKey) {
    this.ossKey = ossKey;
    return this;
  }

   /**
   * oss文件路径
   * @return ossKey
  **/
  @ApiModelProperty(value = "oss文件路径")
  public String getOssKey() {
    return ossKey;
  }

  public void setOssKey(String ossKey) {
    this.ossKey = ossKey;
  }

  @JsonIgnore
  public MsImportCasRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsImportCasRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsImportCasRequest operatorName(String operatorName) {
    this.operatorName = operatorName;
    return this;
  }

   /**
   * 操作者姓名
   * @return operatorName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getOperatorName() {
    return operatorName;
  }

  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportCasRequest importCasRequest = (MsImportCasRequest) o;
    return Objects.equals(this.ossKey, importCasRequest.ossKey) &&
        Objects.equals(this.groupid, importCasRequest.groupid) &&
        Objects.equals(this.operatorId, importCasRequest.operatorId) &&
        Objects.equals(this.operatorName, importCasRequest.operatorName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ossKey, groupid, operatorId, operatorName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportCasRequest {\n");
    
    sb.append("    ossKey: ").append(toIndentedString(ossKey)).append("\n");
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    operatorName: ").append(toIndentedString(operatorName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
