package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 银行帐号是否已存在请求
 */
@ApiModel(description = "银行帐号是否已存在请求")

@JsonInclude(NON_NULL)
public class MsIsExistBankAccountRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("casid")
  private Long casid = null;

  @JsonProperty("bankName")
  private String bankName = null;

  @JsonProperty("bankAccount")
  private String bankAccount = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonIgnore
  public MsIsExistBankAccountRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 接口表主键
   * @return id
  **/
  @ApiModelProperty(value = "接口表主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsIsExistBankAccountRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsIsExistBankAccountRequest casid(Long casid) {
    this.casid = casid;
    return this;
  }

   /**
   * 客商id
   * @return casid
  **/
  @ApiModelProperty(value = "客商id")
  public Long getCasid() {
    return casid;
  }

  public void setCasid(Long casid) {
    this.casid = casid;
  }

  @JsonIgnore
  public MsIsExistBankAccountRequest bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

   /**
   * 银行名称
   * @return bankName
  **/
  @ApiModelProperty(value = "银行名称")
  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  @JsonIgnore
  public MsIsExistBankAccountRequest bankAccount(String bankAccount) {
    this.bankAccount = bankAccount;
    return this;
  }

   /**
   * 银行账号
   * @return bankAccount
  **/
  @ApiModelProperty(value = "银行账号")
  public String getBankAccount() {
    return bankAccount;
  }

  public void setBankAccount(String bankAccount) {
    this.bankAccount = bankAccount;
  }

  @JsonIgnore
  public MsIsExistBankAccountRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsIsExistBankAccountRequest isExistBankAccountRequest = (MsIsExistBankAccountRequest) o;
    return Objects.equals(this.id, isExistBankAccountRequest.id) &&
        Objects.equals(this.groupid, isExistBankAccountRequest.groupid) &&
        Objects.equals(this.casid, isExistBankAccountRequest.casid) &&
        Objects.equals(this.bankName, isExistBankAccountRequest.bankName) &&
        Objects.equals(this.bankAccount, isExistBankAccountRequest.bankAccount) &&
        Objects.equals(this.operatorId, isExistBankAccountRequest.operatorId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupid, casid, bankName, bankAccount, operatorId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsIsExistBankAccountRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    casid: ").append(toIndentedString(casid)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    bankAccount: ").append(toIndentedString(bankAccount)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
