package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 票面信息是否已存在默认请求
 */
@ApiModel(description = "票面信息是否已存在默认请求")

@JsonInclude(NON_NULL)
public class MsIsExistDefaultInvoiceRequest {
  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("casid")
  private Long casid = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonIgnore
  public MsIsExistDefaultInvoiceRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsIsExistDefaultInvoiceRequest casid(Long casid) {
    this.casid = casid;
    return this;
  }

   /**
   * 客商id
   * @return casid
  **/
  @ApiModelProperty(value = "客商id")
  public Long getCasid() {
    return casid;
  }

  public void setCasid(Long casid) {
    this.casid = casid;
  }

  @JsonIgnore
  public MsIsExistDefaultInvoiceRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsIsExistDefaultInvoiceRequest isExistDefaultInvoiceRequest = (MsIsExistDefaultInvoiceRequest) o;
    return Objects.equals(this.groupid, isExistDefaultInvoiceRequest.groupid) &&
        Objects.equals(this.casid, isExistDefaultInvoiceRequest.casid) &&
        Objects.equals(this.operatorId, isExistDefaultInvoiceRequest.operatorId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupid, casid, operatorId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsIsExistDefaultInvoiceRequest {\n");
    
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    casid: ").append(toIndentedString(casid)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
