package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.casm.model.MsCasDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询客商详细信息返回
 */
@ApiModel(description = "查询客商详细信息返回")

@JsonInclude(NON_NULL)
public class MsListCasDetailsResult {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsCasDetails> result = new ArrayList<MsCasDetails>();

  @JsonIgnore
  public MsListCasDetailsResult code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsListCasDetailsResult message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsListCasDetailsResult result(List<MsCasDetails> result) {
    this.result = result;
    return this;
  }

  public MsListCasDetailsResult addResultItem(MsCasDetails resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 客商明细信息
   * @return result
  **/
  @ApiModelProperty(value = "客商明细信息")
  public List<MsCasDetails> getResult() {
    return result;
  }

  public void setResult(List<MsCasDetails> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListCasDetailsResult listCasDetailsResult = (MsListCasDetailsResult) o;
    return Objects.equals(this.code, listCasDetailsResult.code) &&
        Objects.equals(this.message, listCasDetailsResult.message) &&
        Objects.equals(this.result, listCasDetailsResult.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListCasDetailsResult {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
