package com.xforceplus.phoenix.casm.model;

import java.util.List;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询客商主信息请求
 */
@ApiModel(description = "查询客商主信息请求")

@JsonInclude(NON_NULL)
public class MsListCasRequest {
  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("casType")
  private Integer casType = null;

  @JsonProperty("param")
  private String param = null;

  @JsonProperty("paramType")
  private Integer paramType = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  private Boolean isAdministrator;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("currentPage")
  private Integer currentPage = null;

  @JsonProperty("selectedIdList")
  private List<Long> selectedIdList = null;

  @JsonProperty("binding")
  private Boolean binding = null;

  public Boolean getBinding() {
    return binding;
  }

  public void setBinding(Boolean binding) {
    this.binding = binding;
  }

  public List<Long> getSelectedIdList() {
    return selectedIdList;
  }

  public void setSelectedIdList(List<Long> selectedIdList) {
    this.selectedIdList = selectedIdList;
  }

  @JsonIgnore
  public MsListCasRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsListCasRequest casType(Integer casType) {
    this.casType = casType;
    return this;
  }

   /**
   * 客商类型:1-客户2-供应商3-客户和供应商
   * @return casType
  **/
  @ApiModelProperty(value = "客商类型:1-客户2-供应商3-客户和供应商")
  public Integer getCasType() {
    return casType;
  }

  public void setCasType(Integer casType) {
    this.casType = casType;
  }

  @JsonIgnore
  public MsListCasRequest param(String param) {
    this.param = param;
    return this;
  }

   /**
   * 编号或企业税号或企业名称
   * @return param
  **/
  @ApiModelProperty(value = "编号或企业税号或企业名称")
  public String getParam() {
    return param;
  }

  public void setParam(String param) {
    this.param = param;
  }

  @JsonIgnore
  public MsListCasRequest paramType(Integer paramType) {
    this.paramType = paramType;
    return this;
  }

   /**
   * 参数类型 1公司名称 2编号 3税号 4个人
   * @return paramType
  **/
  @ApiModelProperty(value = "参数类型 1公司名称 2编号 3税号 4个人")
  public Integer getParamType() {
    return paramType;
  }

  public void setParamType(Integer paramType) {
    this.paramType = paramType;
  }

  @JsonIgnore
  public MsListCasRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }

  @JsonIgnore
  public MsListCasRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页显示数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页显示数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsListCasRequest currentPage(Integer currentPage) {
    this.currentPage = currentPage;
    return this;
  }

   /**
   * 当前页
   * @return currentPage
  **/
  @ApiModelProperty(value = "当前页")
  public Integer getCurrentPage() {
    return currentPage;
  }

  public void setCurrentPage(Integer currentPage) {
    this.currentPage = currentPage;
  }

  public Boolean getAdministrator() {
    return isAdministrator;
  }

  public void setAdministrator(Boolean administrator) {
    isAdministrator = administrator;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListCasRequest listCasRequest = (MsListCasRequest) o;
    return Objects.equals(this.groupid, listCasRequest.groupid) &&
        Objects.equals(this.casType, listCasRequest.casType) &&
        Objects.equals(this.param, listCasRequest.param) &&
        Objects.equals(this.paramType, listCasRequest.paramType) &&
        Objects.equals(this.operatorId, listCasRequest.operatorId) &&
        Objects.equals(this.pageSize, listCasRequest.pageSize) &&
        Objects.equals(this.currentPage, listCasRequest.currentPage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupid, casType, param, paramType, operatorId, pageSize, currentPage);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListCasRequest {\n");
    
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    casType: ").append(toIndentedString(casType)).append("\n");
    sb.append("    param: ").append(toIndentedString(param)).append("\n");
    sb.append("    paramType: ").append(toIndentedString(paramType)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    currentPage: ").append(toIndentedString(currentPage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
