package com.xforceplus.phoenix.casm.model.otc;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@NoArgsConstructor
@Data
public class TradeHeaderAPIData implements Serializable {
    private Long id;
    /**
     * 租户id
     * 表 : trade_header
     * 对应字段 : tenant_id
     */
    private Long tenantId;

    /**
     * 规则ID
     * 表 : trade_header
     * 对应字段 : schema_id
     */
    private Long schemaId;

    /**
     * 规则编号
     * 表 : trade_header
     * 对应字段 : schema_code
     */
    private String schemaCode;

    /**
     * 零售商编码
     * 表 : trade_header
     * 对应字段 : retailer_code
     */
    private String retailerCode;

    /**
     * 零售商名称
     * 表 : trade_header
     * 对应字段 : retailer_name
     */
    private String retailerName;

    /**
     * 门店编码
     * 表 : trade_header
     * 对应字段 : store_code
     */
    private String storeCode;

    /**
     * 门店名称
     * 表 : trade_header
     * 对应字段 : store_name
     */
    private String storeName;

    /**
     * 供应商编码
     * 表 : trade_header
     * 对应字段 : supplier_code
     */
    private String supplierCode;

    /**
     * 供应商名称
     * 表 : trade_header
     * 对应字段 : supplier_name
     */
    private String supplierName;

    /**
     * 物流模式
     * 表 : trade_header
     * 对应字段 : shipped_by
     */
    private String shippedBy;

    /**
     * 大仓编码
     * 表 : trade_header
     * 对应字段 : warehouse_code
     */
    private String warehouseCode;

    /**
     * 售达方编码
     * 表 : trade_header
     * 对应字段 : sold_to_party_code
     */
    private String soldToPartyCode;

    /**
     * 售达方名称
     * 表 : trade_header
     * 对应字段 : sold_to_party_name
     */
    private String soldToPartyName;

    /**
     * 送达方编码
     * 表 : trade_header
     * 对应字段 : ship_to_party_code
     */
    private String shipToPartyCode;

    /**
     * 送达方名称
     * 表 : trade_header
     * 对应字段 : ship_to_party_name
     */
    private String shipToPartyName;

    /**
     * 收票方编码
     * 表 : trade_header
     * 对应字段 : bill_to_party_code
     */
    private String billToPartyCode;

    /**
     * 收票方名称
     * 表 : trade_header
     * 对应字段 : bill_to_party_name
     */
    private String billToPartyName;

    /**
     * 付款方编码
     * 表 : trade_header
     * 对应字段 : payer_code
     */
    private String payerCode;

    /**
     * 付款方名称
     * 表 : trade_header
     * 对应字段 : payer_name
     */
    private String payerName;

    /**
     * 销售组织
     * 表 : trade_header
     * 对应字段 : sales_organization
     */
    private String salesOrganization;

    /**
     * 销售组织名称
     * 表 : trade_header
     * 对应字段 : sales_organization_name
     */
    private String salesOrganizationName;

    /**
     * 自定义字段
     * 表 : trade_header
     * 对应字段 : custom_properties
     */
    @JsonIgnore
    private String customProperties;

    /**
     * 删除标识
     * 表 : trade_header
     * 对应字段 : deletion_flag
     */
    private Long deletionFlag;

    /**
     * 创建人
     * 表 : trade_header
     * 对应字段 : created_by
     */
    private Long createdBy;

    /**
     * 创建时间
     * 表 : trade_header
     * 对应字段 : created_at
     */

    private Date createdAt;

    /**
     * 更新人
     * 表 : trade_header
     * 对应字段 : modified_by
     */
    private Long modifiedBy;

    /**
     * 更新时间
     * 表 : trade_header
     * 对应字段 : modified_at
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date modifiedAt;



    private List<CustomProperties> customPropertyList;
}
