package com.xforceplus.phoenix.casm.model.otc;


import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Data
public class TradeHeaderSimpleRequest {
    /**
     * 租户id
     * 表 : schema_field
     * 对应字段 : tenant_id
     */
    Long tenantId;

    /**
     * 模式id
     * 表 : schema_field
     * 对应字段 : schema_id
     */
    private Long schemaId;


    private @NotNull(
            message = "schemaCode不能为空")
    String schemaCode;


    @NotNull(message = "retailerCode不能为空")
    @Size(max = 30, message = "retailerCode长度不能超过30")
    private String retailerCode;


    @Size(max = 100, message = "retailerName长度不能超过100")
    private String retailerName;


    @NotNull(message = "storeCode不能为空")
    @Size(max = 30, message = "storeCode长度不能超过30")
    private String storeCode;

    private String storeName;

    @NotNull(message = "supplierCode不能为空")
    @Size(max = 30, message = "supplierCode长度不能超过30")
    private String supplierCode;

    private String supplierName;


    @Size(max = 30, message = "shippedBy长度不能超过30")
    private String shippedBy;


    @Size(max = 30, message = "warehouseCode长度不能超过30")
    private String warehouseCode;

    private Integer pageNumber = 1;

    private Integer pageSize = 20;
}