package com.xforceplus.phoenix.casm.model.relation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.phoenix.casm.model.PageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;


@ApiModel(description = "用户和客商 匹配查询返回结果信息")
@Data
public class UserCasmRelationData implements Serializable {

    @ApiModelProperty("人员和客户关系List")
    @JsonProperty("userCustomerRelationList")
    private List<UserCustomerRelationInfo> userCustomerRelationList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class UserCasmRelationRequest implements Serializable {
        @ApiModelProperty(value = "租户Id")
        @JsonProperty("tenantId")
        private Long tenantId;
        @ApiModelProperty(value = "用户Id")
        @JsonProperty("userId")
        private Long userId;
        @ApiModelProperty(value = "客户编号")
        @JsonProperty("customerNo")
        private String customerNo;
        @ApiModelProperty(value = "客户名称")
        @JsonProperty("customerName")
        private String customerName;
        @ApiModelProperty(value = "客户纳税人识别号")
        @JsonProperty("customerTaxNo")
        private String customerTaxNo;
        @ApiModelProperty(value = "分页信息")
        @JsonProperty("pageInfo")
        private PageInfo pageInfo;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CasmRequest implements Serializable {
        @ApiModelProperty(value = "租户Id")
        @JsonProperty("tenantId")
        private Long tenantId;

        @ApiModelProperty(value = "客商编号List")
        @JsonProperty("customerNoList")
        private List<String> customerNoList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class RelationResult implements Serializable {
        @ApiModelProperty(value = "id")
        @JsonProperty("id")
        private Long id;

        @ApiModelProperty(value = "手机账号")
        @JsonProperty("mobile")
        private String mobile;

        @ApiModelProperty(value = "邮箱账号")
        @JsonProperty("email")
        private String email;

        @ApiModelProperty(value = "其它账号/域账号")
        @JsonProperty("accountName")
        private String accountName;

        @ApiModelProperty(value = "姓名")
        @JsonProperty("userName")
        private String userName;

        @ApiModelProperty(value = "所属租户Id")
        @JsonProperty("tenantId")
        private Long tenantId;

        @ApiModelProperty(value = "userId")
        @JsonProperty("userId")
        private Long userId;

        @ApiModelProperty(value = "客户编号")
        @JsonProperty("customerNo")
        private String customerNo;

        @ApiModelProperty(value = "客户名称")
        @JsonProperty("customerName")
        private String customerName;

        @ApiModelProperty(value = "客户纳税人识别号")
        @JsonProperty("customerTaxNo")
        private String customerTaxNo;

        @ApiModelProperty(value = "客户公司")
        @JsonProperty("customerCompany")
        private String customerCompany;

        @ApiModelProperty(value = "客户分类")
        @JsonProperty("customerCategory")
        private String customerCategory;

        @ApiModelProperty(value = "客户组")
        @JsonProperty("customerGroup")
        private String customerGroup;

        @ApiModelProperty(value = "状态(0:无效 1:有效)")
        @JsonProperty("status")
        private Integer status;
    }


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class UserCustomerRelationInfo implements Serializable {
        @ApiModelProperty(value = "id")
        @JsonProperty("id")
        private Long id;

        @ApiModelProperty("手机号码")
        @JsonProperty("mobile")
        private String mobile;

        @ApiModelProperty("邮箱")
        @JsonProperty("email")
        private String email;

        @ApiModelProperty("用户Id")
        @JsonProperty("userId")
        private Long userId;

        @ApiModelProperty("用户名称")
        @JsonProperty("userName")
        private String userName;

        @ApiModelProperty("其它/域账号名")
        @JsonProperty("accountName")
        private String accountName;

        @ApiModelProperty("用户所属租户id")
        @JsonProperty("tenantId")
        private Long tenantId;

        @ApiModelProperty("客户编号")
        @JsonProperty("customerNo")
        private String customerNo;

        @ApiModelProperty("启用状态： 1-启用、 0-停用")
        @JsonProperty("status")
        private Integer status;

        @ApiModelProperty("客户名称")
        @JsonProperty("customerName")
        private String customerName;

        @ApiModelProperty("客户税号")
        @JsonProperty("customerTaxNo")
        private String customerTaxNo;

        @ApiModelProperty("客户分类")
        @JsonProperty("customerCategory")
        private String customerCategory;

        @ApiModelProperty("客户租")
        @JsonProperty("customerGroup")
        private String customerGroup;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SaveUserCustomerRelationResult implements Serializable {
        @ApiModelProperty("保存数量")
        @JsonProperty("saveNum")
        private Integer saveNum;

        @ApiModelProperty("更新数量")
        @JsonProperty("updateNum")
        private Integer updateNum;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class AuthorizedCustomerNoInfo implements Serializable {
        @ApiModelProperty("具有权限的客商编号集合")
        @JsonProperty("customerNoList")
        private List<String> customerNoList;

        @ApiModelProperty("使用人员客商模块标识 true 使用了绑定了关系 false 未使用过")
        @JsonProperty("usingCustomerReleation")
        private Boolean usingCustomerReleation;
    }

}
