package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.casm.model.MsCasInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import javax.validation.constraints.*;

/**
 * 查询客商主信息请求返回
 */
@ApiModel(description = "查询客商主信息请求返回")
@Data
@JsonInclude(NON_NULL)
public class MsCasInfoModel {
  @JsonProperty("consumersTotal")
  private Integer consumersTotal = null;

  @JsonProperty("suppliersTotal")
  private Integer suppliersTotal = null;

  /**
   * 个人类型总数
   */
  @JsonIgnore
  @JsonProperty("pTotal")
  private Integer pTotal = null;

  @JsonProperty("channelTotal")
  private Integer channelTotal = null;

  @JsonProperty("casInfos")
  private List<MsCasInfo> casInfos = new ArrayList<MsCasInfo>();


}
