package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsCasLabelInfo {
  @JsonProperty("casLabel")
  private String casLabel = null;

  @JsonProperty("CasTaxNo")
  private String casTaxNo = null;

  @JsonIgnore
  public MsCasLabelInfo casLabel(String casLabel) {
    this.casLabel = casLabel;
    return this;
  }

   /**
   * 标签
   * @return casLabel
  **/
  @ApiModelProperty(value = "标签")
  public String getCasLabel() {
    return casLabel;
  }

  public void setCasLabel(String casLabel) {
    this.casLabel = casLabel;
  }

  @JsonIgnore
  public MsCasLabelInfo casTaxNo(String casTaxNo) {
    this.casTaxNo = casTaxNo;
    return this;
  }

   /**
   * 客商税号
   * @return casTaxNo
  **/
  @ApiModelProperty(value = "客商税号")
  public String getCasTaxNo() {
    return casTaxNo;
  }

  public void setCasTaxNo(String casTaxNo) {
    this.casTaxNo = casTaxNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCasLabelInfo casLabelInfo = (MsCasLabelInfo) o;
    return Objects.equals(this.casLabel, casLabelInfo.casLabel) &&
        Objects.equals(this.casTaxNo, casLabelInfo.casTaxNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(casLabel, casTaxNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCasLabelInfo {\n");
    
    sb.append("    casLabel: ").append(toIndentedString(casLabel)).append("\n");
    sb.append("    casTaxNo: ").append(toIndentedString(casTaxNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
