package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 税号、编号是否已存在请求
 */
@ApiModel(description = "税号、编号是否已存在请求")

@JsonInclude(NON_NULL)
public class MsIsExistSubNoRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("param")
  private String param = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonIgnore
  public MsIsExistSubNoRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 接口表主键
   * @return id
  **/
  @ApiModelProperty(value = "接口表主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsIsExistSubNoRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsIsExistSubNoRequest param(String param) {
    this.param = param;
    return this;
  }

   /**
   * 企业税号\\编号
   * @return param
  **/
  @ApiModelProperty(value = "企业税号\\编号")
  public String getParam() {
    return param;
  }

  public void setParam(String param) {
    this.param = param;
  }

  @JsonIgnore
  public MsIsExistSubNoRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsIsExistSubNoRequest isExistSubNoRequest = (MsIsExistSubNoRequest) o;
    return Objects.equals(this.id, isExistSubNoRequest.id) &&
        Objects.equals(this.groupid, isExistSubNoRequest.groupid) &&
        Objects.equals(this.param, isExistSubNoRequest.param) &&
        Objects.equals(this.operatorId, isExistSubNoRequest.operatorId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupid, param, operatorId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsIsExistSubNoRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    param: ").append(toIndentedString(param)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
