package com.xforceplus.phoenix.casm.api;

import com.xforceplus.openapi.domain.entity.common.OpenApiResponse;
import com.xforceplus.phoenix.casm.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "partnerApi")
public interface PartnerApi {

    @ApiOperation(value = "批量查询客商信息", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/batchQuery",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse batchQueryPartnerInfo(@ApiParam(value = "批量查询客商信息请求" ,required=true ) @RequestBody BatchQueryRequest request);

    @ApiOperation(value = "修改客商抬头信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "casm", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/casmIndex/updateCasHeader",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse updateCasHeader(@ApiParam(value = "抬头信息修改请求" ,required=true ) @RequestBody UpdateHeaderRequest request);

    @ApiOperation(value = "客商与人员关系页面查询", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/user",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse queryPartnerUser(@ApiParam(value = "客商与人员关系查询" ,required=true ) @RequestBody QueryUserRequest request);

    @ApiOperation(value = "客商与角色关系页面查询", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/role",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse queryPartnerRole(@ApiParam(value = "客商与角色关系查询" ,required=true ) @RequestBody QueryUserRequest request);

    @ApiOperation(value = "操作客商与角色关系", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/role/operate",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse operatePartnerRole(@ApiParam(value = "操作客商与角色关系请求" ,required=true ) @RequestBody OperateUserRequest request);

    @ApiOperation(value = "操作客商与用户关系", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/user/operate",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse operatePartnerUser(@ApiParam(value = "操作客商与用户关系请求" ,required=true ) @RequestBody OperateUserRequest request);

    @ApiOperation(value = "客商与人员关系查询", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/user/confirm",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse confirmPartnerUser(@ApiParam(value = "客商与人员关系查询" ,required=true) @RequestBody ConfirmUserRequest request);

    @ApiOperation(value = "客商与角色关系查询", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/role/confirm",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse confirmPartnerRole(@ApiParam(value = "客商与角色关系查询" ,required=true) @RequestBody ConfirmUserRequest request);

    @ApiOperation(value = "公司名称模糊查询请求", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/invoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse queryInvoiceInfo(@ApiParam(value = "公司名称模糊查询请求" ,required=true) @RequestBody CompanyNameRequest request);

    @ApiOperation(value = "票面信息抬头Id查询请求", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/invoiceTitle",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OpenApiResponse queryInvoiceTitle(@ApiParam(value = "票面信息抬头Id查询请求" ,required=true) @RequestBody InvoiceTitleRequest request);

    @ApiOperation(value = "操作客商组织树标识", response = Response.class, tags={ "partner"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "通用的回复格式", response = Response.class) })
    @RequestMapping(value = "/partner/binding",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response bindingCas(@ApiParam(value = "绑定标识请求" ,required=true) @RequestBody BindingRequest request);
}
