package com.xforceplus.phoenix.casm.model;

import com.xforceplus.openapi.domain.entity.common.Page;
import com.xforceplus.openapi.domain.entity.common.Sort;
import com.xforceplus.openapi.domain.entity.common.WhereCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel("抬头信息批量查询请求")
public class BatchQueryRequest {

    @ApiModelProperty("查询条件")
    private List<WhereCondition> conditions;
    @ApiModelProperty("分页")
    private Page page;
    @ApiModelProperty("排序")
    private List<Sort> sorts;

    public List<WhereCondition> getConditions() {
        return conditions;
    }

    public void setConditions(List<WhereCondition> conditions) {
        this.conditions = conditions;
    }

    public Page getPage() {
        return page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public List<Sort> getSorts() {
        return sorts;
    }

    public void setSorts(List<Sort> sorts) {
        this.sorts = sorts;
    }

    public BatchQueryRequest() {
    }

    public BatchQueryRequest(List<WhereCondition> conditions, Page page, List<Sort> sorts) {
        this.conditions = conditions;
        this.page = page;
        this.sorts = sorts;
    }
}
