package com.xforceplus.phoenix.casm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 查询公司信息返回
 */
@ApiModel(description = "查询公司信息返回")
@Data
public class CasInfosResult {

    @JsonProperty("code")
    private Integer code = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("result")
    private Map<String, List<MsCasDetails>> result = new HashMap<>();

    @JsonIgnore
    public CasInfosResult code(Integer code) {
        this.code = code;
        return this;
    }

    @JsonIgnore
    public CasInfosResult message(String message) {
        this.message = message;
        return this;
    }

    @JsonIgnore
    public CasInfosResult result(Map<String, List<MsCasDetails>> result) {
        this.result = result;
        return this;
    }
}
