package com.xforceplus.phoenix.casm.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/***
 * identifierNo或taxNo+enterpriseName
 * 
 * @author andy.zhou
 *
 */

@Data
@ApiModel("客商需要维护信息")
public class CasmInfo {
	@ApiModelProperty("groupId")
	private Long groupId;
	
	// 客商类型:1-客户2-供应商3-客户和供应商
	@ApiModelProperty("客商类型:1-客户2-供应商3-客户和供应商")
	private Integer cas_type;

	@ApiModelProperty("客商编号")
	private String identifier_no;

	/**
	 * 2021.9 客商改版后兼容原逻辑保留上面
	 * identifier_no
	 */
	@JsonProperty("identifierNoList")
	private List<MsCasIdentifierNo> identifierNoList = new ArrayList<>();


	@ApiModelProperty("企业税号")
	private String tax_no;
	@ApiModelProperty("企业名称")
	private String enterpriseName;

	@ApiModelProperty("地址")
	private String address;
	@ApiModelProperty("电话")
	private String tel;
	@ApiModelProperty("银行")
	private String bank_name;
	@ApiModelProperty("账号")
	private String bank_account;
	// 来自字段：spare_field1
	@ApiModelProperty("邮箱")
	private String email;

	@JsonProperty("personIdCard")
	private String personIdCard ;

	@ApiModelProperty("客商id")
	private Long casId;

	@ApiModelProperty("请求来源 bill-来源于业务单修改，需要修改税号和名称，与openAPi有差异")
	private String requestFrom;

	@ApiModelProperty("操作人")
	private String userName;
	@ApiModelProperty("操作人id")
	private Long userId;

	@ApiModelProperty("更新客商同时更新业务单和预制发票:1-更新(默认更新) 0-不更新")
	private Integer updateSyncBillFlag;


}
