package com.xforceplus.phoenix.casm.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel("抬头信息")
public class InvoiceHeaderInfo {

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("公司税号")
    private String taxNumber;

    @ApiModelProperty("票面抬头信息id")
    private Long invoiceHeaderId;

    @ApiModelProperty("银行名称")
    private String bankName;

    @ApiModelProperty("银行账号")
    private String bankAccount;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("电话")
    private String tel;

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getTaxNumber() {
        return taxNumber;
    }

    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public Long getInvoiceHeaderId() {
        return invoiceHeaderId;
    }

    public void setInvoiceHeaderId(Long invoiceHeaderId) {
        this.invoiceHeaderId = invoiceHeaderId;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public InvoiceHeaderInfo() {
    }

    public InvoiceHeaderInfo(String companyName, String taxNumber, Long invoiceHeaderId, String bankName, String bankAccount, String address, String tel) {
        this.companyName = companyName;
        this.taxNumber = taxNumber;
        this.invoiceHeaderId = invoiceHeaderId;
        this.bankName = bankName;
        this.bankAccount = bankAccount;
        this.address = address;
        this.tel = tel;
    }
}
