package com.xforceplus.phoenix.casm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 查询客商主信息请求返回
 */
@ApiModel(description = "查询客商主信息请求返回")

@JsonInclude(NON_NULL)
public class MsCasInfo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("casType")
  private Integer casType = null;

  @JsonProperty("casClassify")
  private String casClassify = null;

  @JsonProperty("enterpriseName")
  private String enterpriseName = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("casLabel")
  private String casLabel = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("personIdCard")
  private String personIdCard = null;

  @JsonProperty("CasTaxNo")
  private String casTaxNo = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private Long updateTime = null;

  @JsonProperty("CasIdentifierNos")
  private List<MsCasIdentifierNo> casIdentifierNos = new ArrayList<MsCasIdentifierNo>();

  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsCasInfo id(Long id) {
    this.id = id;
    return this;
  }

  public String getPersonIdCard() {
    return personIdCard;
  }

  public void setPersonIdCard(String personIdCard) {
    this.personIdCard = personIdCard;
  }

  /**
   * 客商id
   * @return id
  **/
  @ApiModelProperty(value = "客商id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCasInfo groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsCasInfo casType(Integer casType) {
    this.casType = casType;
    return this;
  }

   /**
   * 客商类型:1-客户2-供应商3-客户和供应商
   * @return casType
  **/
  @ApiModelProperty(value = "客商类型:1-客户2-供应商3-客户和供应商")
  public Integer getCasType() {
    return casType;
  }

  public void setCasType(Integer casType) {
    this.casType = casType;
  }

  @JsonIgnore
  public MsCasInfo casClassify(String casClassify) {
    this.casClassify = casClassify;
    return this;
  }

   /**
   * 客商分类(用户自定义)
   * @return casClassify
  **/
  @ApiModelProperty(value = "客商分类(用户自定义)")
  public String getCasClassify() {
    return casClassify;
  }

  public void setCasClassify(String casClassify) {
    this.casClassify = casClassify;
  }

  @JsonIgnore
  public MsCasInfo enterpriseName(String enterpriseName) {
    this.enterpriseName = enterpriseName;
    return this;
  }

   /**
   * 企业名称
   * @return enterpriseName
  **/
  @ApiModelProperty(value = "企业名称")
  public String getEnterpriseName() {
    return enterpriseName;
  }

  public void setEnterpriseName(String enterpriseName) {
    this.enterpriseName = enterpriseName;
  }

  @JsonIgnore
  public MsCasInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public MsCasInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  /**
   * 发票类型
   * @return invoiceType
   **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }


  @JsonIgnore
  public MsCasInfo casLabel(String casLabel) {
    this.casLabel = casLabel;
    return this;
  }

   /**
   * 标签
   * @return casLabel
  **/
  @ApiModelProperty(value = "标签")
  public String getCasLabel() {
    return casLabel;
  }

  public void setCasLabel(String casLabel) {
    this.casLabel = casLabel;
  }

  @JsonIgnore
  public MsCasInfo email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 邮箱
   * @return email
  **/
  @ApiModelProperty(value = "邮箱")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsCasInfo casTaxNo(String casTaxNo) {
    this.casTaxNo = casTaxNo;
    return this;
  }

   /**
   * 客商税号
   * @return casTaxNo
  **/
  @ApiModelProperty(value = "客商税号")
  public String getCasTaxNo() {
    return casTaxNo;
  }

  public void setCasTaxNo(String casTaxNo) {
    this.casTaxNo = casTaxNo;
  }

  @JsonIgnore
  public MsCasInfo createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsCasInfo updateTime(Long updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 修改时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "修改时间")
  public Long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Long updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsCasInfo casIdentifierNos(List<MsCasIdentifierNo> casIdentifierNos) {
    this.casIdentifierNos = casIdentifierNos;
    return this;
  }

  public MsCasInfo addCasIdentifierNosItem(MsCasIdentifierNo casIdentifierNosItem) {
    this.casIdentifierNos.add(casIdentifierNosItem);
    return this;
  }

   /**
   * 客商编号信息
   * @return casIdentifierNos
  **/
  @ApiModelProperty(value = "客商编号信息")
  public List<MsCasIdentifierNo> getCasIdentifierNos() {
    return casIdentifierNos;
  }

  public void setCasIdentifierNos(List<MsCasIdentifierNo> casIdentifierNos) {
    this.casIdentifierNos = casIdentifierNos;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCasInfo casInfo = (MsCasInfo) o;
    return Objects.equals(this.id, casInfo.id) &&
        Objects.equals(this.groupid, casInfo.groupid) &&
        Objects.equals(this.casType, casInfo.casType) &&
        Objects.equals(this.casClassify, casInfo.casClassify) &&
        Objects.equals(this.enterpriseName, casInfo.enterpriseName) &&
        Objects.equals(this.remark, casInfo.remark) &&
        Objects.equals(this.invoiceType, casInfo.invoiceType) &&
        Objects.equals(this.casLabel, casInfo.casLabel) &&
        Objects.equals(this.email, casInfo.email) &&
        Objects.equals(this.casTaxNo, casInfo.casTaxNo) &&
        Objects.equals(this.createUserName, casInfo.createUserName) &&
        Objects.equals(this.updateTime, casInfo.updateTime) &&
        Objects.equals(this.casIdentifierNos, casInfo.casIdentifierNos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, groupid, casType, casClassify, enterpriseName, remark, invoiceType,casLabel, email, casTaxNo, createUserName, updateTime, casIdentifierNos);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCasInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    casType: ").append(toIndentedString(casType)).append("\n");
    sb.append("    casClassify: ").append(toIndentedString(casClassify)).append("\n");
    sb.append("    enterpriseName: ").append(toIndentedString(enterpriseName)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    casLabel: ").append(toIndentedString(casLabel)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    casTaxNo: ").append(toIndentedString(casTaxNo)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    casIdentifierNos: ").append(toIndentedString(casIdentifierNos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
