package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 客商票面信息
 */
@ApiModel(description = "客商票面信息")

@JsonInclude(NON_NULL)
public class MsCasInvoiceInfo {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("bankName")
  private String bankName = null;

  @JsonProperty("bankAccount")
  private String bankAccount = null;

  @JsonProperty("address")
  private String address = null;

  @JsonProperty("tel")
  private String tel = null;

  @JsonProperty("defaultFlag")
  private Integer defaultFlag = null;

  @JsonIgnore
  public MsCasInvoiceInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 接口表主键
   * @return id
  **/
  @ApiModelProperty(value = "接口表主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCasInvoiceInfo bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

   /**
   * 银行名称
   * @return bankName
  **/
  @ApiModelProperty(value = "银行名称")
  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  @JsonIgnore
  public MsCasInvoiceInfo bankAccount(String bankAccount) {
    this.bankAccount = bankAccount;
    return this;
  }

   /**
   * 银行账号
   * @return bankAccount
  **/
  @ApiModelProperty(value = "银行账号")
  public String getBankAccount() {
    return bankAccount;
  }

  public void setBankAccount(String bankAccount) {
    this.bankAccount = bankAccount;
  }

  @JsonIgnore
  public MsCasInvoiceInfo address(String address) {
    this.address = address;
    return this;
  }

   /**
   * 地址
   * @return address
  **/
  @ApiModelProperty(value = "地址")
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  @JsonIgnore
  public MsCasInvoiceInfo tel(String tel) {
    this.tel = tel;
    return this;
  }

   /**
   * 电话
   * @return tel
  **/
  @ApiModelProperty(value = "电话")
  public String getTel() {
    return tel;
  }

  public void setTel(String tel) {
    this.tel = tel;
  }

  @JsonIgnore
  public MsCasInvoiceInfo defaultFlag(Integer defaultFlag) {
    this.defaultFlag = defaultFlag;
    return this;
  }

   /**
   * 0非默认项1默认项
   * @return defaultFlag
  **/
  @ApiModelProperty(value = "0非默认项1默认项")
  public Integer getDefaultFlag() {
    return defaultFlag;
  }

  public void setDefaultFlag(Integer defaultFlag) {
    this.defaultFlag = defaultFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCasInvoiceInfo casInvoiceInfo = (MsCasInvoiceInfo) o;
    return Objects.equals(this.id, casInvoiceInfo.id) &&
        Objects.equals(this.bankName, casInvoiceInfo.bankName) &&
        Objects.equals(this.bankAccount, casInvoiceInfo.bankAccount) &&
        Objects.equals(this.address, casInvoiceInfo.address) &&
        Objects.equals(this.tel, casInvoiceInfo.tel) &&
        Objects.equals(this.defaultFlag, casInvoiceInfo.defaultFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, bankName, bankAccount, address, tel, defaultFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCasInvoiceInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    bankAccount: ").append(toIndentedString(bankAccount)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    tel: ").append(toIndentedString(tel)).append("\n");
    sb.append("    defaultFlag: ").append(toIndentedString(defaultFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
