package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询标签请求
 */
@ApiModel(description = "查询标签请求")

@JsonInclude(NON_NULL)
public class MsGetCasLabelByTaxNoRequest {
  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonIgnore
  public MsGetCasLabelByTaxNoRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsGetCasLabelByTaxNoRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 税号
   * @return taxNo
  **/
  @ApiModelProperty(value = "税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetCasLabelByTaxNoRequest getCasLabelByTaxNoRequest = (MsGetCasLabelByTaxNoRequest) o;
    return Objects.equals(this.groupid, getCasLabelByTaxNoRequest.groupid) &&
        Objects.equals(this.taxNo, getCasLabelByTaxNoRequest.taxNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupid, taxNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetCasLabelByTaxNoRequest {\n");
    
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
