package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询客商信息请求
 */
@ApiModel(description = "查询客商信息请求")

@JsonInclude(NON_NULL)
public class MsListCasByTaxNosRequest {
  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("taxNos")
  private List<String> taxNos = new ArrayList<String>();

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonIgnore
  public MsListCasByTaxNosRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

  /**
   * 客商编号
   */
  private String identifierNo;

  @ApiModelProperty(value = "客商编号")
  public String getIdentifierNo() {
    return identifierNo;
  }

  public void setIdentifierNo(String identifierNo) {
    this.identifierNo = identifierNo;
  }

  /**
   * 集团id
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsListCasByTaxNosRequest taxNos(List<String> taxNos) {
    this.taxNos = taxNos;
    return this;
  }

  public MsListCasByTaxNosRequest addTaxNosItem(String taxNosItem) {
    this.taxNos.add(taxNosItem);
    return this;
  }

   /**
   * 税号数组
   * @return taxNos
  **/
  @ApiModelProperty(value = "税号数组")
  public List<String> getTaxNos() {
    return taxNos;
  }

  public void setTaxNos(List<String> taxNos) {
    this.taxNos = taxNos;
  }

  @JsonIgnore
  public MsListCasByTaxNosRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListCasByTaxNosRequest listCasByTaxNosRequest = (MsListCasByTaxNosRequest) o;
    return Objects.equals(this.groupid, listCasByTaxNosRequest.groupid) &&
        Objects.equals(this.taxNos, listCasByTaxNosRequest.taxNos) &&
        Objects.equals(this.operatorId, listCasByTaxNosRequest.operatorId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupid, taxNos, operatorId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListCasByTaxNosRequest {\n");
    
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    taxNos: ").append(toIndentedString(taxNos)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
