package com.xforceplus.phoenix.casm.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询客商主信息请求
 */
@ApiModel(description = "查询客商主信息请求")

@JsonInclude(NON_NULL)
public class MsListCasDetailsRequest {
  @JsonProperty("groupid")
  private Long groupid = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("enterpriseName")
  private String enterpriseName = null;

  @JsonProperty("identifierNo")
  private String identifierNo = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("operatorId")
  private Long operatorId = null;

  @JsonIgnore
  public MsListCasDetailsRequest groupid(Long groupid) {
    this.groupid = groupid;
    return this;
  }

   /**
   * 集团id（必传）
   * @return groupid
  **/
  @ApiModelProperty(value = "集团id（必传）")
  public Long getGroupid() {
    return groupid;
  }

  public void setGroupid(Long groupid) {
    this.groupid = groupid;
  }

  @JsonIgnore
  public MsListCasDetailsRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 客商id
   * @return id
  **/
  @ApiModelProperty(value = "客商id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsListCasDetailsRequest enterpriseName(String enterpriseName) {
    this.enterpriseName = enterpriseName;
    return this;
  }

   /**
   * 企业名称
   * @return enterpriseName
  **/
  @ApiModelProperty(value = "企业名称")
  public String getEnterpriseName() {
    return enterpriseName;
  }

  public void setEnterpriseName(String enterpriseName) {
    this.enterpriseName = enterpriseName;
  }

  @JsonIgnore
  public MsListCasDetailsRequest identifierNo(String identifierNo) {
    this.identifierNo = identifierNo;
    return this;
  }

   /**
   * 客商编号
   * @return identifierNo
  **/
  @ApiModelProperty(value = "客商编号")
  public String getIdentifierNo() {
    return identifierNo;
  }

  public void setIdentifierNo(String identifierNo) {
    this.identifierNo = identifierNo;
  }

  @JsonIgnore
  public MsListCasDetailsRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 企业税号
   * @return taxNo
  **/
  @ApiModelProperty(value = "企业税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public MsListCasDetailsRequest operatorId(Long operatorId) {
    this.operatorId = operatorId;
    return this;
  }

   /**
   * 操作者id
   * @return operatorId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getOperatorId() {
    return operatorId;
  }

  public void setOperatorId(Long operatorId) {
    this.operatorId = operatorId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListCasDetailsRequest listCasDetailsRequest = (MsListCasDetailsRequest) o;
    return Objects.equals(this.groupid, listCasDetailsRequest.groupid) &&
        Objects.equals(this.id, listCasDetailsRequest.id) &&
        Objects.equals(this.enterpriseName, listCasDetailsRequest.enterpriseName) &&
        Objects.equals(this.identifierNo, listCasDetailsRequest.identifierNo) &&
        Objects.equals(this.taxNo, listCasDetailsRequest.taxNo) &&
        Objects.equals(this.operatorId, listCasDetailsRequest.operatorId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupid, id, enterpriseName, identifierNo, taxNo, operatorId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListCasDetailsRequest {\n");
    
    sb.append("    groupid: ").append(toIndentedString(groupid)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    enterpriseName: ").append(toIndentedString(enterpriseName)).append("\n");
    sb.append("    identifierNo: ").append(toIndentedString(identifierNo)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    operatorId: ").append(toIndentedString(operatorId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
