package com.xforceplus.phoenix.casm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 客商更新或新增请求
 */
@ApiModel(description = "客商更新或新增请求")

@JsonInclude(NON_NULL)
public class MsSaveCasRequest {
	@JsonProperty("opType")
	private Integer opType = null;

	@JsonProperty("id")
	private Long id = null;

	@JsonProperty("isOpenApi")
	private boolean openApi = false;

	@ApiModelProperty("针对openAPi改造使用,页面逻辑不用 openApi是否是老版本,老版本是List不传值 新版本是List->带编号带抬头 :默认true")
	private Boolean isOldVersion = true;

	@ApiModelProperty("针对openAPi改造使用,页面逻辑不用 ,更新客商同时更新业务单和预制发票:1-更新(默认更新) 0-不更新")
	private Integer updateSyncBillFlag;


	@JsonProperty("groupid")
	private Long groupid = null;

	@JsonProperty("casType")
	private Integer casType = null;

	@JsonProperty("enterpriseName")
	private String enterpriseName = null;

	@JsonProperty("remark")
	private String remark = null;

	@JsonProperty("casLabel")
	private String casLabel = null;

	@JsonProperty("email")
	private String email = null;


    @JsonProperty("personIdCard")
    private String personIdCard = null;

	@JsonProperty("invoiceType")
	private String invoiceType = null;

	@JsonProperty("operatorId")
	private Long operatorId = null;

	@JsonProperty("operatorName")
	private String operatorName = null;

	@JsonProperty("CasTaxNos")
	private List<MsCasTaxNo> casTaxNos = new ArrayList<MsCasTaxNo>();

	@JsonProperty("CasIdentifierNos")
	private List<MsCasIdentifierNo> casIdentifierNos = new ArrayList<MsCasIdentifierNo>();

	@JsonProperty("CasInvoiceInfos")
	private List<MsCasInvoiceInfo> casInvoiceInfos = new ArrayList<MsCasInvoiceInfo>();

	@JsonIgnore
	public MsSaveCasRequest opType(Integer opType) {
		this.opType = opType;
		return this;
	}

	public Integer getUpdateSyncBillFlag() {
		return updateSyncBillFlag;
	}

	public void setUpdateSyncBillFlag(Integer updateSyncBillFlag) {
		this.updateSyncBillFlag = updateSyncBillFlag;
	}

	public Boolean getOldVersion() {
		return isOldVersion;
	}

	public void setOldVersion(Boolean oldVersion) {
		isOldVersion = oldVersion;
	}

	/**
	 * 操作类型1-新增/0-更新
	 * 
	 * @return opType
	 **/
	@ApiModelProperty(value = "操作类型1-新增/0-更新")
	public Integer getOpType() {
		return opType;
	}

	public void setOpType(Integer opType) {
		this.opType = opType;
	}

	@JsonIgnore
	public MsSaveCasRequest id(Long id) {
		this.id = id;
		return this;
	}

	public String getPersonIdCard() {
		return personIdCard;
	}

	public void setPersonIdCard(String personIdCard) {
		this.personIdCard = personIdCard;
	}

	/**
	 * 客商id
	 * 
	 * @return id
	 **/
	@ApiModelProperty(value = "客商id")
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@JsonIgnore
	public MsSaveCasRequest groupid(Long groupid) {
		this.groupid = groupid;
		return this;
	}

	/**
	 * 集团id
	 * 
	 * @return groupid
	 **/
	@ApiModelProperty(value = "集团id")
	public Long getGroupid() {
		return groupid;
	}

	public void setGroupid(Long groupid) {
		this.groupid = groupid;
	}

	@ApiModelProperty(value = "是不是openApi调用,默认为否")
	public boolean isOpenApi() {
		return openApi;
	}

	public void setOpenApi(boolean openApi) {
		this.openApi = openApi;
	}

	@JsonIgnore
	public MsSaveCasRequest casType(Integer casType) {
		this.casType = casType;
		return this;
	}

	/**
	 * 客商类型:1-客户2-供应商3-客户和供应商
	 * 
	 * @return casType
	 **/
	@ApiModelProperty(value = "客商类型:1-客户2-供应商3-客户和供应商")
	public Integer getCasType() {
		return casType;
	}

	public void setCasType(Integer casType) {
		this.casType = casType;
	}

	@JsonIgnore
	public MsSaveCasRequest enterpriseName(String enterpriseName) {
		this.enterpriseName = enterpriseName;
		return this;
	}

	/**
	 * 企业名称
	 * 
	 * @return enterpriseName
	 **/
	@ApiModelProperty(value = "企业名称")
	public String getEnterpriseName() {
		return enterpriseName;
	}

	public void setEnterpriseName(String enterpriseName) {
		this.enterpriseName = enterpriseName;
	}

	@JsonIgnore
	public MsSaveCasRequest remark(String remark) {
		this.remark = remark;
		return this;
	}

	/**
	 * 备注
	 * 
	 * @return remark
	 **/
	@ApiModelProperty(value = "备注")
	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	@JsonIgnore
	public MsSaveCasRequest casLabel(String casLabel) {
		this.casLabel = casLabel;
		return this;
	}

	/**
	 * 标签
	 * 
	 * @return casLabel
	 **/
	@ApiModelProperty(value = "标签")
	public String getCasLabel() {
		return casLabel;
	}

	public void setCasLabel(String casLabel) {
		this.casLabel = casLabel;
	}

	@JsonIgnore
	public MsSaveCasRequest email(String email) {
		this.email = email;
		return this;
	}

	/**
	 * 邮箱
	 * 
	 * @return email
	 **/
	@ApiModelProperty(value = "邮箱")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	@JsonIgnore
	public MsSaveCasRequest invoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
		return this;
	}

	/**
	 * 发票类型
	 *
	 * @return invoiceType
	 **/
	@ApiModelProperty(value = "发票类型")
	public String getInvoiceType() {
		return invoiceType;
	}

	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}


	@JsonIgnore
	public MsSaveCasRequest operatorId(Long operatorId) {
		this.operatorId = operatorId;
		return this;
	}

	/**
	 * 操作者id
	 * 
	 * @return operatorId
	 **/
	@ApiModelProperty(value = "操作者id")
	public Long getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(Long operatorId) {
		this.operatorId = operatorId;
	}

	@JsonIgnore
	public MsSaveCasRequest operatorName(String operatorName) {
		this.operatorName = operatorName;
		return this;
	}

	/**
	 * 操作者姓名
	 * 
	 * @return operatorName
	 **/
	@ApiModelProperty(value = "操作者姓名")
	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	@JsonIgnore
	public MsSaveCasRequest casTaxNos(List<MsCasTaxNo> casTaxNos) {
		this.casTaxNos = casTaxNos;
		return this;
	}

	public MsSaveCasRequest addCasTaxNosItem(MsCasTaxNo casTaxNosItem) {
		this.casTaxNos.add(casTaxNosItem);
		return this;
	}

	/**
	 * 客商税号信息
	 * 
	 * @return casTaxNos
	 **/
	@ApiModelProperty(value = "客商税号信息")
	public List<MsCasTaxNo> getCasTaxNos() {
		return casTaxNos;
	}

	public void setCasTaxNos(List<MsCasTaxNo> casTaxNos) {
		this.casTaxNos = casTaxNos;
	}

	@JsonIgnore
	public MsSaveCasRequest casIdentifierNos(List<MsCasIdentifierNo> casIdentifierNos) {
		this.casIdentifierNos = casIdentifierNos;
		return this;
	}

	public MsSaveCasRequest addCasIdentifierNosItem(MsCasIdentifierNo casIdentifierNosItem) {
		this.casIdentifierNos.add(casIdentifierNosItem);
		return this;
	}

	/**
	 * 客商编号信息
	 * 
	 * @return casIdentifierNos
	 **/
	@ApiModelProperty(value = "客商编号信息")
	public List<MsCasIdentifierNo> getCasIdentifierNos() {
		return casIdentifierNos;
	}

	public void setCasIdentifierNos(List<MsCasIdentifierNo> casIdentifierNos) {
		this.casIdentifierNos = casIdentifierNos;
	}

	@JsonIgnore
	public MsSaveCasRequest casInvoiceInfos(List<MsCasInvoiceInfo> casInvoiceInfos) {
		this.casInvoiceInfos = casInvoiceInfos;
		return this;
	}

	public MsSaveCasRequest addCasInvoiceInfosItem(MsCasInvoiceInfo casInvoiceInfosItem) {
		this.casInvoiceInfos.add(casInvoiceInfosItem);
		return this;
	}

	/**
	 * 客商票面信息
	 * 
	 * @return casInvoiceInfos
	 **/
	@ApiModelProperty(value = "客商票面信息")
	public List<MsCasInvoiceInfo> getCasInvoiceInfos() {
		return casInvoiceInfos;
	}

	public void setCasInvoiceInfos(List<MsCasInvoiceInfo> casInvoiceInfos) {
		this.casInvoiceInfos = casInvoiceInfos;
	}

	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		MsSaveCasRequest saveCasRequest = (MsSaveCasRequest) o;
		return Objects.equals(this.opType, saveCasRequest.opType) && Objects.equals(this.id, saveCasRequest.id)
				&& Objects.equals(this.groupid, saveCasRequest.groupid)
				&& Objects.equals(this.openApi, saveCasRequest.openApi)
				&& Objects.equals(this.casType, saveCasRequest.casType)
				&& Objects.equals(this.enterpriseName, saveCasRequest.enterpriseName)
				&& Objects.equals(this.remark, saveCasRequest.remark)
				&& Objects.equals(this.casLabel, saveCasRequest.casLabel)
				&& Objects.equals(this.email, saveCasRequest.email)
				&& Objects.equals(this.invoiceType, saveCasRequest.invoiceType)
				&& Objects.equals(this.operatorId, saveCasRequest.operatorId)
				&& Objects.equals(this.operatorName, saveCasRequest.operatorName)
				&& Objects.equals(this.casTaxNos, saveCasRequest.casTaxNos)
				&& Objects.equals(this.casIdentifierNos, saveCasRequest.casIdentifierNos)
				&& Objects.equals(this.casInvoiceInfos, saveCasRequest.casInvoiceInfos);
	}

	@Override
	public int hashCode() {
		return Objects.hash(opType, id, groupid, openApi, casType, enterpriseName, remark, casLabel, email,
				invoiceType,operatorId, operatorName, casTaxNos, casIdentifierNos, casInvoiceInfos);
	}

	@Override
	public String toString() {
		return "MsSaveCasRequest{" +
				"opType=" + opType +
				", id=" + id +
				", openApi=" + openApi +
				", updateSyncBillFlag=" + updateSyncBillFlag +
				", groupid=" + groupid +
				", casType=" + casType +
				", enterpriseName='" + enterpriseName + '\'' +
				", remark='" + remark + '\'' +
				", casLabel='" + casLabel + '\'' +
				", email='" + email + '\'' +
				", invoiceType ='" + invoiceType + '\'' +
				", operatorId=" + operatorId +
				", operatorName='" + operatorName + '\'' +
				", casTaxNos=" + casTaxNos +
				", casIdentifierNos=" + casIdentifierNos +
				", casInvoiceInfos=" + casInvoiceInfos +
				'}';
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}

}
