package com.xforceplus.phoenix.casm.model;

import com.xforceplus.openapi.domain.entity.common.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("查询客商信息与用户或角色关系请求")
public class QueryUserRequest {

    @ApiModelProperty("客商税号")
    private String taxNumber;

    @ApiModelProperty("客商编号")
    private String partnerNo;

    @ApiModelProperty("用户id或角色id")
    private Long parameter;

    @ApiModelProperty("客商类型")
    private Integer partnerType;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("产线id")
    private Long appId;

    private Byte queryType;

    @ApiModelProperty("页码")
    private Integer pageNo;

    @ApiModelProperty("页数")
    private Integer pageSize;

}
