/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.snowflake;

import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class SnowflakeldCheckService {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeldCheckService.class);
    @Value(value="${server-config.ant-coop-route.lan-url:http://xxxx}")
    private String antCoopRouteUrl;
    static RestTemplate restTemplate = new RestTemplate();
    static Long heartbeatDatacenterId = null;
    static Long heartbeatWorkerId = null;

    public boolean check(Long datacenterId, Long workerId, String ip) {
        try {
            String url = this.antCoopRouteUrl + "/global/coop/coop-route/v1/id-generator/check?datacenterId={datacenterId}&workerId={workerId}&ip={ip}";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datacenterId", datacenterId);
            params.put("workerId", workerId);
            params.put("ip", ip);
            String rs = (String)restTemplate.getForObject(url, String.class, params);
            log.info("###### \u5206\u5e03\u5f0fID \u6570\u636e\u68c0\u6d4bresponse\uff1a {}", (Object)rs);
            if ("0".equals(rs)) {
                heartbeatDatacenterId = datacenterId;
                heartbeatWorkerId = workerId;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("##### \u5206\u5e03\u5f0fID\u4f7f\u7528\u672c\u8eab\u914d\u7f6e/\u968f\u673a\u751f\u6210\u6570\u636e\uff0c\u68c0\u6d4b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return true;
        }
    }

    public void heartbeat() {
        try {
            if (null == heartbeatDatacenterId) {
                log.warn("##### \u5206\u5e03\u5f0fID\u5065\u5eb7\u68c0\u67e5 \u65e0\u5fc3\u8df3\u6570\u636e\u4e0d\u53d1\u9001\u68c0\u6d4b");
                return;
            }
            log.info("##### \u5206\u5e03\u5f0fID\u5065\u5eb7\u68c0\u67e5:[heartbeatDatacenterId:{};heartbeatWorkerId:{};]", (Object)heartbeatDatacenterId, (Object)heartbeatWorkerId);
            String url = this.antCoopRouteUrl + "/global/coop/coop-route/v1/id-generator/heartbeat?datacenterId={datacenterId}&workerId={workerId}";
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("datacenterId", heartbeatDatacenterId);
            params.put("workerId", heartbeatWorkerId);
            String rs = (String)restTemplate.getForObject(url, String.class, params);
            log.info("###### \u5206\u5e03\u5f0fID[datacenterId\uff1a{}; workerId\uff1a{}] \u5fc3\u8df3\u7ed3\u679cresponse\uff1a {}", new Object[]{heartbeatDatacenterId, heartbeatWorkerId, rs});
        }
        catch (Exception e) {
            log.error("##### \u5206\u5e03\u5f0fID[datacenterId\uff1a{}; workerId\uff1a{}] \u5fc3\u8df3\u5f02\u5e38\uff1a{}", new Object[]{heartbeatDatacenterId, heartbeatWorkerId, e.getMessage()});
        }
    }

    public void timer() {
        log.info("##### \u5206\u5e03\u5f0fID \u6570\u636e\u5fc3\u8df3\u68c0\u67e5\u542f\u52a8");
        try {
            ScheduledExecutorService pool = Executors.newScheduledThreadPool(1);
            pool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    SnowflakeldCheckService.this.heartbeat();
                }
            }, 3600L, 3600L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ArrayBlockingQueue<Runnable> workQueueL1 = new ArrayBlockingQueue<Runnable>(10);
        ThreadPoolExecutor customExecutorL1 = new ThreadPoolExecutor(1, 2, 200L, TimeUnit.SECONDS, workQueueL1, new ThreadPoolExecutor.CallerRunsPolicy());
        int i = 0;
        while (i < 20) {
            System.out.println(i);
            final int tag = i++;
            customExecutorL1.submit(new Runnable(){

                @Override
                public void run() {
                    System.out.println("\u7ebf\u7a0b\u300b\u300b\u300b" + tag);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        System.out.println(workQueueL1.size());
    }
}

