/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.coop.common.utils.HttpRequestFactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CommonMsokenService {
    private static final Logger log = LoggerFactory.getLogger(CommonMsokenService.class);
    private RestTemplate restTemplate = new RestTemplate(HttpRequestFactoryUtil.simpleClientHttpRequestFactory());
    @Value(value="${coop.security.msCenter.gatewayUrl:https://paas.xforceplus.com}")
    private String gatewayUrl;
    @Value(value="${coop.security.msCenter.clientId:tg_coop-production-line}")
    private String clientId;
    @Value(value="${coop.security.msCenter.clientSecret:scvsa.fndaslowueoq@}")
    private String clientSecret;
    @Value(value="${coop.security.msCenter.tokenCacheTime:2}")
    private Integer tokenCacheTime;
    private static String cacheToken;
    private static Long cacheTime;

    public String getMsAuthToken() {
        String cacheToken = this.getCacheToken();
        if (null != cacheToken) {
            log.info("##### \u83b7\u53d6\u672c\u5730\u7f13\u5b58\u8ba4\u8bc1token: {}", (Object)cacheToken);
            return cacheToken;
        }
        JSONObject clientTokenReq = new JSONObject();
        clientTokenReq.put("clientId", (Object)this.clientId);
        clientTokenReq.put("secret", (Object)this.clientSecret);
        log.info("\u8fd0\u8425\u4e2d\u5fc3\u83b7\u53d6\u7f51\u5173\u8bbf\u95eeTOKEN--\u8bf7\u6c42url\uff1a{}", (Object)this.gatewayUrl);
        log.info("\u8fd0\u8425\u4e2d\u5fc3\u83b7\u53d6\u7f51\u5173\u8bbf\u95eeTOKEN--\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)clientTokenReq.toJSONString());
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)clientTokenReq, (MultiValueMap)requestHeaders);
        String clientTokenResp = (String)this.restTemplate.postForObject(this.gatewayUrl + "/api/client/login", (Object)requestEntity, String.class, new Object[0]);
        log.info("\u8fd0\u8425\u4e2d\u5fc3\u83b7\u53d6\u7f51\u5173\u8bbf\u95eeTOKEN--\u56de\u590d\u62a5\u6587\uff1a{}", (Object)clientTokenResp);
        JSONObject respJson = JSON.parseObject((String)clientTokenResp);
        if (respJson == null || !"1".equals(respJson.getString("code"))) {
            throw new RuntimeException("\u8fd0\u8425\u4e2d\u5fc3\u83b7\u53d6\u7f51\u5173\u8bbf\u95eeTOKEN \u5931\u8d25");
        }
        String token = respJson.getString("data");
        this.setCacheToken(token);
        return token;
    }

    private synchronized void setCacheToken(String token) {
        cacheTime = System.currentTimeMillis() + (long)(this.tokenCacheTime * 60 * 60 * 1000);
        cacheToken = token;
        log.info("##### \u672c\u5730\u7f13\u5b58\u65f6\u95f4\uff1a{} \u5c0f\u65f6 \u5fae\u670d\u52a1\u8ba4\u8bc1token\uff1a{}", (Object)this.tokenCacheTime, (Object)token);
    }

    private synchronized String getCacheToken() {
        if (null != cacheToken) {
            if (cacheTime > System.currentTimeMillis()) {
                return cacheToken;
            }
            cacheToken = null;
        }
        return null;
    }

    public static void deleteCacheToken() {
        cacheToken = null;
        cacheTime = 0L;
    }
}

