/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.dingtalk;

import com.xforceplus.coop.common.dingtalk.DingTalkMessage;
import com.xforceplus.coop.common.dingtalk.enums.MessageLevelEnum;
import com.xforceplus.coop.common.snowflake.IdGenerator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class DingtalkTool {
    private static final Logger log = LoggerFactory.getLogger(DingtalkTool.class);
    private static RestTemplate staticRestTemplate = new RestTemplate();

    public static void send(Environment environment, String title, MessageLevelEnum levelEnum, String content) {
        DingtalkTool.send(staticRestTemplate, environment, title, levelEnum, content);
    }

    public static void send(RestTemplate restTemplate, Environment environment, String title, MessageLevelEnum levelEnum, String content) {
        try {
            String appName = environment.getProperty("spring.application.name", "\u672a\u77e5");
            String dingtalkWebhook = environment.getProperty("coop.alarm.dingtalkWebhook");
            if (StringUtils.isEmpty((Object)dingtalkWebhook)) {
                throw new RuntimeException("\u672a\u914d\u7f6e coop.alarm.dingtalkWebhook \u9489\u9489\u6d88\u606f\u53d1\u9001url");
            }
            DingtalkTool.sendMessage(restTemplate, title, appName, levelEnum, false, null, content, dingtalkWebhook);
        }
        catch (Exception e) {
            log.error("##### \u9489\u9489\u62a5\u8b66\u6d88\u606f\u53d1\u9001\u5f02\u5e38: {}", (Throwable)e);
        }
    }

    private static void sendMessage(RestTemplate restTemplate, String title, String appName, MessageLevelEnum levelEnum, boolean atAll, List<String> atMobiles, String content, String dingtalkWebhook) {
        try {
            DingTalkMessage dingTalkMessage = new DingTalkMessage();
            dingTalkMessage.setMsgtype("markdown");
            DingTalkMessage.MarkdownInfo markdownInfo = new DingTalkMessage.MarkdownInfo();
            markdownInfo.setTitle(title);
            dingTalkMessage.getAt().setAtAll(atAll);
            if (!atAll) {
                dingTalkMessage.getAt().setAtMobiles(atMobiles);
            }
            String messageId = String.valueOf(IdGenerator.nextId());
            StringBuffer sb = new StringBuffer();
            sb.append("#### \u62a5\u8b66\u540d\u79f0: ").append(title).append("\n");
            sb.append("#### \u6d88\u606f\u7ea7\u522b: ").append(DingtalkTool.getLevelMesssage(levelEnum)).append("\n");
            sb.append("#### \u62a5\u8b66\u65f6\u95f4: ").append(DingtalkTool.getTime()).append("\n");
            sb.append("#### \u5e94\u7528\u540d: ").append(appName).append("\n");
            sb.append("#### \u6d88\u606fID: ").append(messageId).append("\n");
            sb.append("```\n");
            sb.append(content).append("\n");
            sb.append("```\n");
            if (!atAll && !CollectionUtils.isEmpty(atMobiles)) {
                sb.append("\n");
                for (String atMobile : atMobiles) {
                    sb.append("* ").append("@").append(atMobile).append("\n");
                }
            }
            markdownInfo.setText(sb.toString());
            dingTalkMessage.setMarkdown(markdownInfo);
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Content-Type", "application/json");
            HttpEntity httpEntity = new HttpEntity((Object)dingTalkMessage, (MultiValueMap)httpHeaders);
            log.warn("##### \u53d1\u9001\u9489\u9489\u544a\u8b66\u6d88\u606f\u8bf7\u6c42\u6d88\u606fID: {}", (Object)messageId);
            log.debug("##### \u53d1\u9001\u9489\u9489\u544a\u8b66\u6d88\u606f\u8bf7\u6c42: {}", (Object)dingTalkMessage);
            ResponseEntity responseEntity = restTemplate.exchange(dingtalkWebhook, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            log.debug("##### \u53d1\u9001\u9489\u9489\u544a\u8b66\u6d88\u606f\u54cd\u5e94: {}", (Object)responseEntity);
        }
        catch (Exception e) {
            log.error("##### \u53d1\u9001\u9489\u9489\u544a\u8b66\u6d88\u606f\u5f02\u5e38: {}", (Throwable)e);
        }
    }

    private static String getLevelMesssage(MessageLevelEnum levelEnum) {
        String tmp = "<font color=\"%s\">" + levelEnum.message() + "</font>";
        switch (levelEnum) {
            case FATAL: {
                return String.format(tmp, "#b30000");
            }
            case ERROR: {
                return String.format(tmp, "#ff0066");
            }
            case WARN: {
                return String.format(tmp, "#e68a00");
            }
            case INFO: {
                return String.format(tmp, "#00b300");
            }
            case DEBUG: {
                return String.format(tmp, "#0033cc");
            }
        }
        return levelEnum.message();
    }

    private static String getTime() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime time = LocalDateTime.now();
        String localTime = df.format(time);
        return localTime;
    }
}

