/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.enums;

import com.xforceplus.coop.common.enums.InvoiceTypeEnum;
import java.util.stream.Stream;

public enum InvoiceKindEnum {
    NORMAL("c", "\u7eb8\u8d28\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09"),
    SPECIAL("s", "\u7eb8\u8d28\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09"),
    ELECTRONIC("ce", "\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09"),
    ELECTRONIC_SPECIAL("se", "\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09"),
    VEHICLE("v", "\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968"),
    SECOND_HAND_VEHICLE("vs", "\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968"),
    NORMAL_ROLL("ju", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09");

    private String type;
    private String desc;

    private InvoiceKindEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String value() {
        return this.type;
    }

    public String desc() {
        return this.desc;
    }

    public static InvoiceKindEnum fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceKindEnum.values()).filter(t -> t.value().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968\u79cd"));
    }

    public static boolean isNormal(String invoiceKind) {
        return NORMAL.value().equals(invoiceKind) || ELECTRONIC.value().equals(invoiceKind) || NORMAL_ROLL.value().equals(invoiceKind);
    }

    public static boolean isSpecial(String invoiceKind) {
        return SPECIAL.value().equals(invoiceKind) || ELECTRONIC_SPECIAL.value().equals(invoiceKind);
    }

    public static boolean isElectronic(String invoiceKind) {
        return ELECTRONIC.value().equals(invoiceKind) || ELECTRONIC_SPECIAL.value().equals(invoiceKind);
    }

    public static String specialToNormal(String invoiceKind) {
        if (SPECIAL.value().equals(invoiceKind)) {
            return NORMAL.value();
        }
        if (ELECTRONIC_SPECIAL.value().equals(invoiceKind)) {
            return ELECTRONIC.value();
        }
        return invoiceKind;
    }

    public static InvoiceKindEnum convertFromType(String invoiceType) {
        InvoiceTypeEnum invoiceTypeEnum = InvoiceTypeEnum.fromValue(invoiceType);
        switch (invoiceTypeEnum) {
            case NORMAL: 
            case ALL_NORMAL: {
                return NORMAL;
            }
            case SPECIAL: 
            case ALL_SPECIAL: {
                return SPECIAL;
            }
            case ELECTRONIC: 
            case ALL_ELECTRONIC: {
                return ELECTRONIC;
            }
            case ELECTRONIC_SPECIAL: 
            case ALL_ELECTRONIC_SPECIAL: {
                return ELECTRONIC_SPECIAL;
            }
            case NORMAL_ROLL: {
                return NORMAL_ROLL;
            }
            case VEHICLE: {
                return VEHICLE;
            }
            case SECOND_HAND_VEHICLE: {
                return SECOND_HAND_VEHICLE;
            }
        }
        throw new RuntimeException(String.format("\u53d1\u7968\u7c7b\u578b\u3010%s\u3011\u65e0\u5bf9\u5e94\u53d1\u7968\u7968\u79cd", invoiceType));
    }

    public String getKindValueByType(String invoiceType) {
        try {
            return InvoiceKindEnum.convertFromType(invoiceType).value();
        }
        catch (Exception e) {
            return null;
        }
    }
}

