/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.enums;

import com.xforceplus.coop.common.enums.InvoiceKindEnum;
import com.xforceplus.coop.common.enums.TaxInvoiceSourceEnum;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public enum InvoiceTypeEnum {
    NORMAL("c", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968"),
    SPECIAL("s", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    VEHICLE("v", "\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968"),
    UNIVERSAL("t", "\u901a\u7528\u673a\u6253\u53d1\u7968"),
    ELECTRONIC("ce", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968"),
    ALL_ELECTRONIC("qc", "\u5168\u7535\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968"),
    ALL_NORMAL("cz", "\u5168\u7535\u589e\u503c\u7a0e\u7eb8\u8d28\u666e\u901a\u53d1\u7968"),
    ELECTRONIC_SPECIAL("se", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968"),
    ALL_ELECTRONIC_SPECIAL("qs", "\u5168\u7535\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968"),
    ALL_SPECIAL("sz", "\u5168\u7535\u589e\u503c\u7a0e\u7eb8\u8d28\u4e13\u7528\u53d1\u7968"),
    NORMAL_ROLL("ju", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u7968)"),
    NORMAL_TOLL("ct", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968(\u901a\u884c\u8d39)"),
    TRANSPORTATION("y", "\u8fd0\u8f93\u4e1a\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    SECOND_HAND_VEHICLE("vs", "\u4e8c\u624b\u8f66\u53d1\u7968"),
    IMPORT_VAT_PAYMENT("cp", "\u8fdb\u53e3\u589e\u503c\u7a0e\u7f34\u6b3e\u4e66\u53d1\u7968");

    private final String type;
    private final String desc;

    private InvoiceTypeEnum(String type, String description) {
        this.type = type;
        this.desc = description;
    }

    public String value() {
        return this.type;
    }

    public String desc() {
        return this.desc;
    }

    public static InvoiceTypeEnum fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceTypeEnum.values()).filter(t -> t.value().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
    }

    public static boolean isNormal(String invoiceType) {
        return NORMAL.value().equals(invoiceType) || ELECTRONIC.value().equals(invoiceType) || NORMAL_ROLL.value().equals(invoiceType) || ALL_ELECTRONIC.value().equals(invoiceType) || ALL_NORMAL.value().equals(invoiceType);
    }

    public static boolean isSpecial(String invoiceType) {
        return SPECIAL.value().equals(invoiceType) || ELECTRONIC_SPECIAL.value().equals(invoiceType) || ALL_ELECTRONIC_SPECIAL.value().equals(invoiceType) || ALL_SPECIAL.value().equals(invoiceType);
    }

    public static boolean isElectronic(String invoiceType) {
        return ELECTRONIC.value().equals(invoiceType) || ELECTRONIC_SPECIAL.value().equals(invoiceType) || ALL_ELECTRONIC.value().equals(invoiceType) || ALL_ELECTRONIC_SPECIAL.value().equals(invoiceType);
    }

    public static boolean isAll(String invoiceType) {
        return ALL_ELECTRONIC.value().equals(invoiceType) || ALL_ELECTRONIC_SPECIAL.value().equals(invoiceType) || ALL_NORMAL.value().equals(invoiceType) || ALL_SPECIAL.value().equals(invoiceType);
    }

    public static List<String> special() {
        return Arrays.asList(SPECIAL.value(), ELECTRONIC_SPECIAL.value(), ALL_ELECTRONIC_SPECIAL.value(), ALL_SPECIAL.value());
    }

    public static List<String> normal() {
        return Arrays.asList(NORMAL.value(), ALL_NORMAL.value(), ELECTRONIC.value(), ALL_ELECTRONIC.value(), NORMAL_ROLL.value());
    }

    public static List<String> electronic() {
        return Arrays.asList(ELECTRONIC.value(), ELECTRONIC_SPECIAL.value(), ALL_ELECTRONIC.value(), ALL_ELECTRONIC_SPECIAL.value());
    }

    public static List<String> all() {
        return Arrays.asList(ALL_NORMAL.value(), ALL_SPECIAL.value(), ALL_ELECTRONIC.value(), ALL_ELECTRONIC_SPECIAL.value());
    }

    public static InvoiceTypeEnum convertFromKingAndSource(String invoiceKind, String source) {
        InvoiceKindEnum invoiceKindEnum = InvoiceKindEnum.fromValue(invoiceKind);
        if (TaxInvoiceSourceEnum.isAll(source)) {
            if (InvoiceKindEnum.NORMAL.equals((Object)invoiceKindEnum)) {
                return ALL_NORMAL;
            }
            if (InvoiceKindEnum.SPECIAL.equals((Object)invoiceKindEnum)) {
                return ALL_SPECIAL;
            }
            if (InvoiceKindEnum.ELECTRONIC.equals((Object)invoiceKindEnum)) {
                return ALL_ELECTRONIC;
            }
            if (InvoiceKindEnum.ELECTRONIC_SPECIAL.equals((Object)invoiceKindEnum)) {
                return ALL_ELECTRONIC_SPECIAL;
            }
        } else if (TaxInvoiceSourceEnum.isSk(source)) {
            if (InvoiceKindEnum.NORMAL.equals((Object)invoiceKindEnum)) {
                return NORMAL;
            }
            if (InvoiceKindEnum.SPECIAL.equals((Object)invoiceKindEnum)) {
                return SPECIAL;
            }
            if (InvoiceKindEnum.ELECTRONIC.equals((Object)invoiceKindEnum)) {
                return ELECTRONIC;
            }
            if (InvoiceKindEnum.ELECTRONIC_SPECIAL.equals((Object)invoiceKindEnum)) {
                return ELECTRONIC_SPECIAL;
            }
            if (InvoiceKindEnum.VEHICLE.equals((Object)invoiceKindEnum)) {
                return VEHICLE;
            }
            if (InvoiceKindEnum.SECOND_HAND_VEHICLE.equals((Object)invoiceKindEnum)) {
                return SECOND_HAND_VEHICLE;
            }
            if (InvoiceKindEnum.NORMAL_ROLL.equals((Object)invoiceKindEnum)) {
                return NORMAL_ROLL;
            }
        }
        throw new RuntimeException(String.format("\u53d1\u7968\u7968\u79cd\u3010%s\u3011+\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u3010%s\u3011\u65e0\u6cd5\u8f6c\u6362\u6210\u53d1\u7968\u7c7b\u578b", invoiceKind, source));
    }

    public String getTypeByKindAndSource(String invoiceKind, String taxInvoiceSource) {
        try {
            return InvoiceTypeEnum.convertFromKingAndSource(invoiceKind, taxInvoiceSource).value();
        }
        catch (Exception e) {
            return null;
        }
    }
}

