/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.enums;

import com.xforceplus.coop.common.enums.InvoiceTypeEnum;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum TaxInvoiceSourceEnum {
    DEFAULT("", "\u9ed8\u8ba4\u7a7a"),
    QD("qd", "\u5168\u7535\u53d1\u7968"),
    SK("sk", "\u7a0e\u63a7\u53d1\u7968");

    private String type;
    private String desc;

    private TaxInvoiceSourceEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String value() {
        return this.type;
    }

    public String desc() {
        return this.desc;
    }

    public static TaxInvoiceSourceEnum fromValue(String type) {
        return Arrays.stream(TaxInvoiceSourceEnum.values()).filter(taxInvoiceSourceEnum -> taxInvoiceSourceEnum.value().equals(type)).findFirst().orElse(DEFAULT);
    }

    public static boolean isAll(String type) {
        return QD.value().equals(type);
    }

    public static boolean isSk(String type) {
        return SK.value().equals(type);
    }

    public static TaxInvoiceSourceEnum convertFromType(String invoiceType) {
        if (StringUtils.isEmpty((CharSequence)invoiceType)) {
            return DEFAULT;
        }
        if (InvoiceTypeEnum.isAll(invoiceType)) {
            return QD;
        }
        return SK;
    }
}

