/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.snowflake;

import com.xforceplus.coop.common.dingtalk.DingtalkTool;
import com.xforceplus.coop.common.dingtalk.enums.MessageLevelEnum;
import com.xforceplus.coop.common.snowflake.ISnowflake;
import com.xforceplus.coop.common.snowflake.SnowflakeIdWorker;
import com.xforceplus.coop.common.snowflake.SnowflakeldCheckService;
import com.xforceplus.coop.common.snowflake.ext.NodeUtil;
import com.xforceplus.coop.common.snowflake.ext.PhoenixIDGeneratorService;
import com.xforceplus.coop.common.snowflake.ext.Snowflake;
import java.net.InetAddress;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);
    @Autowired
    private Environment environment;
    @Autowired
    SnowflakeldCheckService snowflakeldCheckService;
    @Autowired
    PhoenixIDGeneratorService phoenixIDGeneratorService;
    @Value(value="${coop.coopIdGenerator.enabled:true}")
    private Boolean coopIdGeneratorEnabled;
    @Value(value="${coop.phoenixIdGenerator.enabled:false}")
    private Boolean phoenixIdGeneratorEnabled;
    static ISnowflake snowflakeIdWorker = new SnowflakeIdWorker(RandomUtils.nextInt((int)1, (int)1000) & 0x1F, RandomUtils.nextInt((int)1, (int)1000) & 0x1F);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        Class<SnowflakeIdWorker> clazz = SnowflakeIdWorker.class;
        synchronized (SnowflakeIdWorker.class) {
            if (this.phoenixIdGeneratorEnabled.booleanValue()) {
                ISnowflake phoenixSnowflake = this.phoenixIdGenerator();
                log.info("##### \u6267\u884c phoenix idGenerator\u7b56\u7565\uff0c\u8fd4\u56deiSnowflake: {}", (Object)phoenixSnowflake);
                if (null != phoenixSnowflake) {
                    snowflakeIdWorker = phoenixSnowflake;
                    log.info("##### \u6267\u884c phoenix idGenerator \u8c03\u7528\u6210\u529f,\u76f4\u63a5\u8fd4\u56de,\u4e0d\u6267\u884ccoopIdGenerator \u7b56\u7565");
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            log.info("##### phoenix idGenerator \u672a\u6267\u884c\u6216\u8005\u83b7\u53d6\u5931\u8d25\uff0c\u7ee7\u7eed\u6267\u884ccoopIdGenerator \u7b56\u7565");
            if (this.coopIdGeneratorEnabled.booleanValue()) {
                ISnowflake coopSnowflake = this.coopIdGenerator();
                log.info("##### \u6267\u884c coop idGenerator\u7b56\u7565\uff0c\u8fd4\u56deiSnowflake: {}", (Object)coopSnowflake);
                if (null != coopSnowflake) {
                    snowflakeIdWorker = coopSnowflake;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static long nextId() {
        return snowflakeIdWorker.nextId();
    }

    public static long[] nextId(int size) {
        return snowflakeIdWorker.nextId(size);
    }

    private synchronized ISnowflake phoenixIdGenerator() {
        Long workerId = null;
        String ip = null;
        String mac = null;
        try {
            ip = NodeUtil.getNodeIp();
            mac = String.format("COOP:%s", NodeUtil.getMac());
            for (int i = 1; i <= 5; ++i) {
                workerId = this.phoenixIDGeneratorService.getWorkerId(mac, ip);
                log.info("##### phoenix\u5206\u5e03\u5f0fID workerId\u83b7\u53d6 [\u7b2c{}\u6b21], mac:{};ip:{}; workerId:{}", new Object[]{i, mac, ip, workerId});
                if (workerId > 1023L) {
                    DingtalkTool.send(this.environment, "phoenix \u83b7\u53d6\u5230\u975e\u6cd5workerId", MessageLevelEnum.ERROR, String.format("phoenix \u5206\u5e03\u5f0fID \u83b7\u53d6workerId: %d \u5927\u4e8e1023, \u4e0d\u4f7f\u7528", workerId));
                    return null;
                }
                if (null == workerId) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("##### \u5206\u5e03\u5f0fID \u6570\u636e\u68c0\u6d4b\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
        if (null == workerId) {
            log.warn("##### phoenix\u5206\u5e03\u5f0fID,mac:{},ip:{}, \u5c1d\u8bd5\u8fc7 5\u6b21 workerId\u83b7\u53d6\u90fd\u5f02\u5e38\uff0c\u76f4\u63a5\u8fd4\u56de", (Object)mac, (Object)ip);
            return null;
        }
        snowflakeIdWorker = new Snowflake(0L, workerId);
        this.phoenixIDGeneratorService.timer();
        log.info("##### phoenix snowflakeIdWorker IOC\u5b9e\u4f8b\uff1a{}", (Object)snowflakeIdWorker);
        return snowflakeIdWorker;
    }

    private synchronized ISnowflake coopIdGenerator() {
        int workerId;
        Integer datacenterId = (Integer)this.environment.getProperty("coop.appid", Integer.class, null);
        if (null == datacenterId) {
            datacenterId = RandomUtils.nextInt((int)1, (int)31);
            log.warn("##### IDGenerate\u5e94\u7528\u672a\u914d\u7f6e${coop.appid}; datacenterId={} (\u968f\u673a\u751f\u6210)", (Object)datacenterId);
        } else {
            log.info("##### IDGenerate ${coop.appid} \u5df2\u914d\u7f6e datacenterId={}", (Object)datacenterId);
        }
        String ip = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            ip = ia.getHostAddress();
            String localip = StringUtils.substringAfterLast((String)ip, (String)".");
            workerId = Integer.parseInt(localip);
        }
        catch (Exception e) {
            workerId = RandomUtils.nextInt((int)1, (int)31);
        }
        log.info("##### \u521d\u59cb\u5316\u8be5\u8282\u70b9\u5206\u914d\u7684workerID={}\uff1b(workerID & 31)={}", (Object)workerId, (Object)(workerId & 0x1F));
        long checkWorkerId = workerId & 0x1F;
        long checkDatacenterId = datacenterId & 0x1F;
        if (this.coopIdGeneratorEnabled.booleanValue()) {
            try {
                for (int i = 1; i <= 35; ++i) {
                    if (this.snowflakeldCheckService.check(checkDatacenterId, checkWorkerId, ip)) {
                        this.snowflakeldCheckService.timer();
                    }
                    ++checkWorkerId;
                    log.info("##### \u5206\u5e03\u5f0fID \u6570\u636e\u68c0\u6d4b[\u7b2c{}\u6b21], checkDatacenterId:{};checkWorkerId:{};ip:{}", new Object[]{i, checkDatacenterId, checkWorkerId &= 0x1FL, ip});
                }
            }
            catch (Exception e) {
                log.error("##### \u5206\u5e03\u5f0fID \u6570\u636e\u68c0\u6d4b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        } else {
            log.info("##### IdGenerator \u8fdc\u7a0b\u76d1\u6d4b\u670d\u52a1\u5df2\u5173\u95ed");
        }
        log.info("##### \u68c0\u6d4b\u540e\u7684\u8be5\u8282\u70b9\u5206\u914d\u7684datacenterId={}\uff1b(workerID & 31)={}", (Object)checkDatacenterId, (Object)checkWorkerId);
        snowflakeIdWorker = new SnowflakeIdWorker(checkWorkerId, checkDatacenterId);
        log.info("##### coop snowflakeIdWorker IOC\u5b9e\u4f8b\uff1a{}", (Object)snowflakeIdWorker);
        return snowflakeIdWorker;
    }

    static {
        log.info("##### snowflakeIdWorker \u9759\u6001\u5b9e\u4f8b\uff1a{}", (Object)snowflakeIdWorker);
    }
}

