/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.snowflake.ext;

import com.alibaba.fastjson.JSON;
import com.xforceplus.coop.common.CommonMsokenService;
import com.xforceplus.coop.common.dingtalk.DingtalkTool;
import com.xforceplus.coop.common.dingtalk.enums.MessageLevelEnum;
import com.xforceplus.coop.common.snowflake.ext.LiveStatusRequest;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class PhoenixIDGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(PhoenixIDGeneratorService.class);
    @Value(value="${server-config.phoenix-id-generator.lan-url:}")
    private String phoenixIdGeneratorUrl;
    @Value(value="${coop.phoenixIdGenerator.workerId-url:/api/v1/distribute-service/apply-workerid}")
    private String workerIdUrl;
    @Value(value="${coop.phoenixIdGenerator.heartbeat-url:/api/v1/distribute-service/send-live-status}")
    private String heartbeatUrl;
    @Autowired
    Environment environment;
    @Autowired
    CommonMsokenService microserviceTokenService;
    protected static RestTemplate restTemplate = new RestTemplate();
    static Long heartbeatWorkerId = null;
    static String heartbeatMac = null;
    static String heartbeatIp = null;

    public Long getWorkerId(String mac, String ip) {
        try {
            if (StringUtils.isBlank((CharSequence)this.phoenixIdGeneratorUrl)) {
                log.warn("\u672a\u914d\u7f6e phoenixIdGeneratorUrl \u83b7\u53d6 workerId,\u76f4\u63a5\u8fd4\u56denull");
                return null;
            }
            StringBuffer url = new StringBuffer(this.phoenixIdGeneratorUrl);
            url.append(this.workerIdUrl).append("?").append("mac=").append(mac).append("&ip=").append(ip);
            log.info("##### phoenix \u5206\u5e03\u5f0fID \u8bf7\u6c42url: {}", (Object)url.toString());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            headers.add("xforce-saas-token", this.microserviceTokenService.getMsAuthToken());
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity resp = restTemplate.exchange(url.toString(), HttpMethod.GET, entity, String.class, new Object[0]);
            log.info("###### mac:{}, ip:{} phoenix \u5206\u5e03\u5f0fID \u83b7\u53d6workerId -> response\uff1a {}", new Object[]{mac, ip, resp});
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resp.getBody()))) {
                heartbeatWorkerId = Long.parseLong((String)resp.getBody());
                heartbeatMac = mac;
                heartbeatIp = ip;
            }
            return heartbeatWorkerId;
        }
        catch (Exception e) {
            DingtalkTool.send(restTemplate, this.environment, "phoenix \u5206\u5e03\u5f0fID \u83b7\u53d6workerId \u5f02\u5e38", MessageLevelEnum.ERROR, e.toString());
            log.error("##### mac:{}, ip:{} phoenix \u5206\u5e03\u5f0fID \u83b7\u53d6workerId\uff0c\u68c0\u6d4b\u5f02\u5e38\uff1a{}", new Object[]{mac, ip, e.getMessage()});
            return null;
        }
    }

    private void heartbeat() {
        try {
            if (StringUtils.isBlank((CharSequence)this.phoenixIdGeneratorUrl)) {
                log.warn("\u672a\u914d\u7f6e phoenixIdGeneratorUrl \u4e0d\u6267\u884cheartbeat");
                return;
            }
            if (null == heartbeatWorkerId) {
                log.warn("##### phoenix  \u5206\u5e03\u5f0fID\u5065\u5eb7\u68c0\u67e5 \u65e0workId\u6570\u636e\u4e0d\u53d1\u9001\u68c0\u6d4b");
                return;
            }
            log.info("##### phoenix \u5206\u5e03\u5f0fID \u5065\u5eb7\u68c0\u67e5:[heartbeatWorkerId:{};heartbeatIp:{};heartbeatMac:{}]", new Object[]{heartbeatWorkerId, heartbeatIp, heartbeatMac});
            String url = this.phoenixIdGeneratorUrl + this.heartbeatUrl;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            headers.add("xforce-saas-token", this.microserviceTokenService.getMsAuthToken());
            LiveStatusRequest request = new LiveStatusRequest(heartbeatWorkerId, heartbeatIp, heartbeatMac);
            HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
            log.info("##### phoenix \u5206\u5e03\u5f0fID\u5065\u5eb7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request));
            ResponseEntity resp = restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            log.info("##### phoenix \u5206\u5e03\u5f0fID\u5065\u5eb7\u68c0\u67e5:[heartbeatWorkerId:{};heartbeatIp:{};heartbeatMac:{}], \u5fc3\u8df3\u7ed3\u679c:{}", new Object[]{heartbeatWorkerId, heartbeatIp, heartbeatMac, resp});
        }
        catch (Exception e) {
            DingtalkTool.send(restTemplate, this.environment, "phoenix \u5206\u5e03\u5f0fID workerId \u53d1\u9001\u5fc3\u8df3\u5f02\u5e38", MessageLevelEnum.ERROR, e.toString());
            log.error("##### phoenix \u5206\u5e03\u5f0fID\u5065\u5eb7\u68c0\u67e5:[heartbeatWorkerId:{};heartbeatIp:{};heartbeatMac:{}], \u5fc3\u8df3\u5f02\u5e38:{}", new Object[]{heartbeatWorkerId, heartbeatIp, heartbeatMac, e.toString()});
        }
    }

    public void timer() {
        log.info("##### phoenix \u5206\u5e03\u5f0fID \u6570\u636e\u5fc3\u8df3\u68c0\u67e5\u542f\u52a8");
        try {
            ScheduledExecutorService pool = Executors.newScheduledThreadPool(1);
            pool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    PhoenixIDGeneratorService.this.heartbeat();
                }
            }, 10L, 10L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

