/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.snowflake.ext;

import com.xforceplus.coop.common.snowflake.ISnowflake;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snowflake
implements ISnowflake {
    private static final Logger log = LoggerFactory.getLogger(Snowflake.class);
    private final long unusedBits = 1L;
    private final long timestampBits = 41L;
    private final long datacenterIdBits = 0L;
    private final long workerIdBits = 10L;
    private final long sequenceBits = 12L;
    private final long maxDatacenterId = 0L;
    private final long maxWorkerId = 1023L;
    private final long maxSequence = 4095L;
    private final long timestampShift = 22L;
    private final long datacenterIdShift = 22L;
    private final long workerIdShift = 12L;
    private final long epoch = 1451606400000L;
    private final long datacenterId;
    private final long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private final int HUNDRED_K = 10000;
    private final AtomicLong waitCount = new AtomicLong(0L);

    @Override
    public synchronized long nextId() {
        long currTimestamp = this.timestampGen();
        if (currTimestamp < this.lastTimestamp) {
            throw new IllegalStateException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - currTimestamp));
        }
        if (currTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currTimestamp = this.waitNextMillis(currTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currTimestamp;
        return currTimestamp - 1451606400000L << 22 | this.datacenterId << 22 | this.workerId << 12 | this.sequence;
    }

    public Snowflake(long datacenterId, long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            int randomWorkerId = new Random().nextInt(Long.valueOf(1023L).intValue());
            log.error("##### phoenix maxWorkerId:{} \u4e0d\u5408\u6cd5[0-1023],\u8fd4\u56de\u7684\u662f\u968f\u673a\u751f\u6210\u7684workerId:{}", (Object)workerId, (Object)randomWorkerId);
            workerId = randomWorkerId;
        }
        this.datacenterId = datacenterId;
        this.workerId = workerId;
    }

    @Override
    public long[] nextId(int size) {
        if (size <= 0 || size > 10000) {
            String message = String.format("Size can't be greater than %d or less than 0", 10000);
            throw new IllegalArgumentException(message);
        }
        long[] ids = new long[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = this.nextId();
        }
        return ids;
    }

    public long getWaitCount() {
        return this.waitCount.get();
    }

    protected long waitNextMillis(long currTimestamp) {
        this.waitCount.incrementAndGet();
        while (currTimestamp <= this.lastTimestamp) {
            currTimestamp = this.timestampGen();
        }
        return currTimestamp;
    }

    protected long timestampGen() {
        return System.currentTimeMillis();
    }

    public String toString() {
        return "Snowflake Settings [timestampBits=41, datacenterIdBits=0, workerIdBits=10, sequenceBits=12, epoch=1451606400000, datacenterId=" + this.datacenterId + ", workerId=" + this.workerId + "]";
    }

    public long getEpoch() {
        return this.epoch;
    }

    public long[] parseId(long id) {
        long[] arr = new long[5];
        arr[4] = (id & this.diode(1L, 41L)) >> 22;
        arr[0] = arr[4] + 1451606400000L;
        arr[1] = (id & this.diode(42L, 0L)) >> 22;
        arr[2] = (id & this.diode(42L, 10L)) >> 12;
        arr[3] = id & this.diode(52L, 12L);
        return arr;
    }

    public String formatId(long id) {
        long[] arr = this.parseId(id);
        String tmf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(arr[0]));
        return String.format("%s, #%d, @(%d,%d)", tmf, arr[3], arr[1], arr[2]);
    }

    private long diode(long offset, long length) {
        int lb = (int)(64L - offset);
        int rb = (int)(64L - (offset + length));
        return -1L << lb ^ -1L << rb;
    }
}

