/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.coop.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;

public class BeanUtils
extends org.springframework.beans.BeanUtils {
    public static void copyProperties(Object source, Object target) throws BeansException {
        BeanUtils.baseCopyProperties(source, target, null);
    }

    public static <T> T copyProperties(Object source, Class<T> targetClass) throws BeansException {
        T target = null;
        try {
            if (null == source) {
                return null;
            }
            target = targetClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BeanUtils.baseCopyProperties(source, target, null);
        return target;
    }

    public static <E, T> List<T> copyList(List<E> sourceList, Class<T> targetClass) throws BeansException {
        ArrayList<T> targetList = new ArrayList<T>();
        if (null == sourceList || null == targetClass) {
            return targetList;
        }
        for (E sourceObj : sourceList) {
            T targetObj = BeanUtils.copyProperties(sourceObj, targetClass);
            targetList.add(targetObj);
        }
        return targetList;
    }

    public static void copyPropertiesSpList(Object source, Object target, Map<String, Class> targetListFieldTypes) throws BeansException {
        BeanUtils.baseCopyProperties(source, target, targetListFieldTypes);
    }

    private static void baseCopyProperties(Object source, Object target, Map<String, Class> targetListFieldTypes) throws BeansException {
        if (null == source || null == target) {
            return;
        }
        PropertyDescriptor[] sourcePds = BeanUtils.getPropertyDescriptors(source.getClass());
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(target.getClass());
        HashMap<String, PropertyDescriptor> targetMaps = new HashMap<String, PropertyDescriptor>(20);
        for (PropertyDescriptor targetPd : targetPds) {
            targetMaps.put(targetPd.getName(), targetPd);
        }
        for (PropertyDescriptor sourcePd : sourcePds) {
            Method writeMethod;
            Method readMethod = sourcePd.getReadMethod();
            if (null == readMethod) continue;
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(true);
            }
            Object sourceValue = null;
            try {
                sourceValue = readMethod.invoke(source, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == sourceValue) continue;
            sourceValue = BeanUtils.convertDateTime(source, sourcePd, sourceValue);
            PropertyDescriptor targetPd = (PropertyDescriptor)targetMaps.get(sourcePd.getName());
            if (null == targetPd || null == (writeMethod = targetPd.getWriteMethod())) continue;
            Class<?> paramType = null;
            try {
                paramType = writeMethod.getParameters()[0].getType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == paramType) continue;
            if (paramType != sourceValue.getClass()) {
                Object customSourceValue = BeanUtils.getCustomSourceValue(sourceValue, target, paramType, targetPd, targetListFieldTypes);
                if (null == customSourceValue) continue;
                sourceValue = customSourceValue;
            }
            try {
                writeMethod.invoke(target, sourceValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Object getCustomSourceValue(Object sourceValue, Object target, Class paramType, PropertyDescriptor targetPd, Map<String, Class> targetListFieldTypes) {
        if (paramType.equals(BigDecimal.class)) {
            return new BigDecimal(sourceValue.toString());
        }
        if (paramType.equals(Long.class)) {
            return Long.valueOf(sourceValue.toString());
        }
        if (paramType.equals(Integer.class)) {
            return Integer.valueOf(sourceValue.toString());
        }
        if (paramType.equals(Integer.TYPE)) {
            return Integer.valueOf(sourceValue.toString());
        }
        if (paramType.equals(String.class) && sourceValue instanceof Date) {
            String dateStr = String.valueOf(((Date)sourceValue).getTime());
            if ("14400000".equals(dateStr)) {
                dateStr = "";
            }
            return dateStr;
        }
        if (paramType.equals(String.class) && sourceValue instanceof LocalDateTime) {
            String dateStr = String.valueOf(((LocalDateTime)sourceValue).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            if ("14400000".equals(dateStr)) {
                dateStr = "";
            }
            return dateStr;
        }
        if (paramType.equals(String.class) && sourceValue instanceof LocalDateTime) {
            return String.valueOf(((LocalDateTime)sourceValue).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        }
        if (paramType.equals(String.class)) {
            return sourceValue.toString();
        }
        if (sourceValue instanceof List && paramType == List.class) {
            Class aClass = null;
            if (null != targetListFieldTypes) {
                aClass = targetListFieldTypes.get(targetPd.getName());
            }
            if (null == aClass && BeanUtils.isListDepthCopy(target, targetPd)) {
                aClass = BeanUtils.getListGenericType(target.getClass(), targetPd.getName());
            }
            if (null == aClass) {
                return sourceValue;
            }
            List sourceList = (List)sourceValue;
            ArrayList targetList = new ArrayList();
            for (Object sourceObj : sourceList) {
                try {
                    Object targetObj = aClass.newInstance();
                    BeanUtils.copyPropertiesSpList(sourceObj, targetObj, null);
                    targetList.add(targetObj);
                }
                catch (Exception exception) {}
            }
            return targetList;
        }
        try {
            Object targetObj = paramType.newInstance();
            BeanUtils.copyPropertiesSpList(sourceValue, targetObj, null);
            return targetObj;
        }
        catch (Exception exception) {
            return sourceValue;
        }
    }

    private static Class getListGenericType(Class aClass, String fieldName) {
        try {
            Field field = aClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            Class<?> curFieldType = field.getType();
            if (curFieldType.equals(List.class)) {
                Type genericType = field.getGenericType();
                if (null == genericType) {
                    return null;
                }
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)genericType;
                    Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
                    return actualTypeArgument;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object convertDateTime(Object classz, PropertyDescriptor propertyDescriptor, Object sourceValue) {
        try {
            Field field = classz.getClass().getDeclaredField(propertyDescriptor.getName());
            if (null != field && null != field.getAnnotation(DateTimeFormat.class)) {
                DateTimeFormat dateTimeFormat = field.getAnnotation(DateTimeFormat.class);
                String format = dateTimeFormat.value();
                LocalDateTime parse = LocalDateTime.parse(sourceValue.toString(), DateTimeFormatter.ofPattern(format));
                sourceValue = parse;
                return sourceValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sourceValue;
    }

    public static boolean isListDepthCopy(Object classz, PropertyDescriptor propertyDescriptor) {
        try {
            Field field = classz.getClass().getDeclaredField(propertyDescriptor.getName());
            if (null != field && null != field.getAnnotation(ListDepth.class)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ListDepth {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DateTimeFormat {
        public String value() default "yyyy-MM-dd HH:mm:ss";
    }
}

