package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsResponse;
import com.xforceplus.ant.system.client.model.MsSaveBusinessDataRequest;
import com.xforceplus.ant.system.client.model.MsSqsMessageListenerRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "common", description = "the common API")
public interface CommonApi {

    @ApiOperation(value = "业务数据保存", notes = "", response = MsResponse.class, tags={ "Common", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/common/saveBusinessData",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse saveBusinessData(@ApiParam(value = "" ,required=true ) @RequestBody MsSaveBusinessDataRequest request);


    @ApiOperation(value = "SQS消息接收", notes = "", response = MsResponse.class, tags={ "Common", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/common/sqsMessageListener",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse sqsMessageListener(@ApiParam(value = "" ,required=true ) @RequestBody MsSqsMessageListenerRequest request);

}
