package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsCrmChangeContractProductsRequest;
import com.xforceplus.ant.system.client.model.MsCrmContactQueryRequest;
import com.xforceplus.ant.system.client.model.MsCrmContactQueryResponse;
import com.xforceplus.ant.system.client.model.MsCrmContractQueryRequest;
import com.xforceplus.ant.system.client.model.MsCrmContractQueryResponse;
import com.xforceplus.ant.system.client.model.MsCrmPolyCmpInfoSyncRequest;
import com.xforceplus.ant.system.client.model.MsCrmProductQueryRequest;
import com.xforceplus.ant.system.client.model.MsCrmProductQueryResponse;
import com.xforceplus.ant.system.client.model.MsCrmSaveContactRequest;
import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "crm", description = "the crm API")
public interface CrmApi {

    @ApiOperation(value = "更换合同产品", notes = "", response = MsResponse.class, tags={ "Crm", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/crm/changeContractProducts",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse changeContractProducts(@ApiParam(value = "request" ,required=true ) @RequestBody MsCrmChangeContractProductsRequest request);


    @ApiOperation(value = "保利供应商主信息同步", notes = "", response = MsResponse.class, tags={ "Crm", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/crm/polyCmpInfoSync",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse polyCmpInfoSync(@ApiParam(value = "request" ,required=true ) @RequestBody MsCrmPolyCmpInfoSyncRequest request);


    @ApiOperation(value = "分页查询联系人列表", notes = "", response = MsCrmContactQueryResponse.class, tags={ "Crm", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsCrmContactQueryResponse.class) })
    @RequestMapping(value = "/crm/queryContactPage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCrmContactQueryResponse queryContactPage(@ApiParam(value = "request" ,required=true ) @RequestBody MsCrmContactQueryRequest request);


    @ApiOperation(value = "分页查询合同列表", notes = "", response = MsCrmContractQueryResponse.class, tags={ "Crm", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsCrmContractQueryResponse.class) })
    @RequestMapping(value = "/crm/queryContractPage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCrmContractQueryResponse queryContractPage(@ApiParam(value = "request" ,required=true ) @RequestBody MsCrmContractQueryRequest request);


    @ApiOperation(value = "分页查询产品列表", notes = "", response = MsCrmProductQueryResponse.class, tags={ "Crm", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsCrmProductQueryResponse.class) })
    @RequestMapping(value = "/crm/queryProductPage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCrmProductQueryResponse queryProductPage(@ApiParam(value = "request" ,required=true ) @RequestBody MsCrmProductQueryRequest request);


    @ApiOperation(value = "保存联系人信息", notes = "", response = MsResponse.class, tags={ "Crm", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/crm/saveContact",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse saveContact(@ApiParam(value = "request" ,required=true ) @RequestBody MsCrmSaveContactRequest request);

}
