package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsAdvertiseAddRequest;
import com.xforceplus.ant.system.client.model.MsAdvertiseModel;
import com.xforceplus.ant.system.client.model.MsAdvertiseQueryRequest;
import com.xforceplus.ant.system.client.model.MsAdvertiseQueryResponse;
import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "gggl", description = "the gggl API")
public interface GgglApi {

    @ApiOperation(value = "添加广告", notes = "", response = MsResponse.class, tags={ "Advertise", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/gggl/add",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse add(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsAdvertiseAddRequest request);


    @ApiOperation(value = "删除广告", notes = "", response = MsResponse.class, tags={ "Advertise", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/gggl/delete",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse delete( @NotNull @ApiParam(value = "主键", required = true) @RequestParam(value = "id", required = true) Long id);


    @ApiOperation(value = "获取广告列表", notes = "", response = MsAdvertiseQueryResponse.class, tags={ "Advertise", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsAdvertiseQueryResponse.class) })
    @RequestMapping(value = "/gggl/queryList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAdvertiseQueryResponse queryList(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsAdvertiseQueryRequest request);


    @ApiOperation(value = "修改广告", notes = "", response = MsResponse.class, tags={ "Advertise", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/gggl/update",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse update(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsAdvertiseModel request);

}
