package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsOperateLogAddRequest;
import com.xforceplus.ant.system.client.model.MsOperateLogQueryRequest;
import com.xforceplus.ant.system.client.model.MsOperateLogQueryResponse;
import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "operateLog", description = "the operateLog API")
public interface OperateLogApi {

    @ApiOperation(value = "添加操作日志", notes = "", response = MsResponse.class, tags={ "OperateLog", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/operateLog/add",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse add(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsOperateLogAddRequest request);


    @ApiOperation(value = "获取操作列表", notes = "", response = MsOperateLogQueryResponse.class, tags={ "OperateLog", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsOperateLogQueryResponse.class) })
    @RequestMapping(value = "/operateLog/queryList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateLogQueryResponse queryList(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsOperateLogQueryRequest request);

}
