package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsResponse;
import com.xforceplus.ant.system.client.model.MsSsoGetUserAccessTokenRequest;
import com.xforceplus.ant.system.client.model.MsSsoResponse;
import com.xforceplus.ant.system.client.model.MsSsoSendSmsLoginCodeRequest;
import com.xforceplus.ant.system.client.model.MsSsoSendSmsLoginCodeResponse;
import com.xforceplus.ant.system.client.model.MsSsoValidateSmsLoginCodeRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "sso", description = "the sso API")
public interface SsoApi {

    @ApiOperation(value = "账号登录", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/sso/accountLogin",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse accountLogin( @NotNull @ApiParam(value = "集团标识", required = true) @RequestParam(value = "token", required = true) String token, @NotNull @ApiParam(value = "跳转密码(解密串)", required = true) @RequestParam(value = "pwd", required = true) String pwd, @ApiParam(value = "重定向前端相对路径") @RequestParam(value = "redirect", required = false) String redirect);


    @ApiOperation(value = "账号登录测试URL", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/sso/accountLoginTestUrl",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse accountLoginTestUrl( @NotNull @ApiParam(value = "登录账号", required = true) @RequestParam(value = "account", required = true) String account, @NotNull @ApiParam(value = "集团标识", required = true) @RequestParam(value = "token", required = true) String token, @NotNull @ApiParam(value = "加密公钥", required = true) @RequestParam(value = "publicKey", required = true) String publicKey, @NotNull @ApiParam(value = "重定向前端相对路径", required = true) @RequestParam(value = "redirect", required = true) String redirect);


    @ApiOperation(value = "添加单点登录 SecretKey", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/sso/addSecretKey",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse addSecretKey( @NotNull @ApiParam(value = "登录账号", required = true) @RequestParam(value = "account", required = true) String account, @NotNull @ApiParam(value = "SecretKey", required = true) @RequestParam(value = "secretKey", required = true) String secretKey, @ApiParam(value = "备注") @RequestParam(value = "remark", required = false) String remark);


    @ApiOperation(value = "获取用户TOKEN", notes = "", response = MsSsoResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsSsoResponse.class) })
    @RequestMapping(value = "/sso/getUserAccessToken",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSsoResponse getUserAccessToken(@ApiParam(value = "request" ,required=true ) @RequestBody MsSsoGetUserAccessTokenRequest request);


    @ApiOperation(value = "手机验证码登录发送", notes = "", response = MsSsoSendSmsLoginCodeResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsSsoSendSmsLoginCodeResponse.class) })
    @RequestMapping(value = "/sso/sendSmsLoginCode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSsoSendSmsLoginCodeResponse sendSmsLoginCode(@ApiParam(value = "request" ,required=true ) @RequestBody MsSsoSendSmsLoginCodeRequest request);


    @ApiOperation(value = "手机验证码登录验证", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/sso/validateSmsLoginCode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse validateSmsLoginCode(@ApiParam(value = "request" ,required=true ) @RequestBody MsSsoValidateSmsLoginCodeRequest request);

}
