package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsResponse;
import com.xforceplus.ant.system.client.model.MsSsoResponse;
import com.xforceplus.ant.system.client.model.MsTCMergeServicePackageRequest;
import com.xforceplus.ant.system.client.model.MsTCMergeServicePackageResponse;
import com.xforceplus.ant.system.client.model.MsTCOneStopEnterRequest;
import com.xforceplus.ant.system.client.model.MsTCOneStopEnterResponse;
import com.xforceplus.ant.system.client.model.MsTCOrderServiceRequest;
import com.xforceplus.ant.system.client.model.MsTCQueryAccountByTaxNoRequest;
import com.xforceplus.ant.system.client.model.MsTCQueryAccountByTaxNoResponse;
import com.xforceplus.ant.system.client.model.MsTCRoleAddRequest;
import com.xforceplus.ant.system.client.model.MsTCUserAddRequest;
import com.xforceplus.ant.system.client.model.MsTCUserRegisterRequest;
import com.xforceplus.ant.system.client.model.MsTCUserRoleAddOrDelRequest;
import com.xforceplus.ant.system.client.model.MsUpdateCoordinationStatusRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "tenantCenter", description = "the tenantCenter API")
public interface TenantCenterApi {

    @ApiOperation(value = "新增或删除用户角色", notes = "", response = MsResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/tenantCenter/addOrDelUserRole",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse addOrDelUserRole(@ApiParam(value = "request" ,required=true ) @RequestBody MsTCUserRoleAddOrDelRequest request);


    @ApiOperation(value = "新增租户角色", notes = "", response = MsResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/tenantCenter/addRole",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse addRole(@ApiParam(value = "request" ,required=true ) @RequestBody MsTCRoleAddRequest request);


    @ApiOperation(value = "新增用户信息", notes = "", response = MsResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/tenantCenter/addUser",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse addUser(@ApiParam(value = "request" ,required=true ) @RequestBody MsTCUserAddRequest request);


    @ApiOperation(value = "一站式入驻灰度购方配置", notes = "", response = MsResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/tenantCenter/getCanaryRouteTenantCodes",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse getCanaryRouteTenantCodes();


    @ApiOperation(value = "合并公司服务包", notes = "", response = MsTCMergeServicePackageResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsTCMergeServicePackageResponse.class) })
    @RequestMapping(value = "/tenantCenter/mergeServicePackage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsTCMergeServicePackageResponse mergeServicePackage(@ApiParam(value = "request" ,required=true ) @RequestBody MsTCMergeServicePackageRequest request);


    @ApiOperation(value = "一站式入驻", notes = "", response = MsTCOneStopEnterResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsTCOneStopEnterResponse.class) })
    @RequestMapping(value = "/tenantCenter/oneStopEnter",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsTCOneStopEnterResponse oneStopEnter(@ApiParam(value = "request" ,required=true ) @RequestBody MsTCOneStopEnterRequest request);


    @ApiOperation(value = "服务包订购", notes = "", response = MsResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/tenantCenter/orderService",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse orderService(@ApiParam(value = "request" ,required=true ) @RequestBody MsTCOrderServiceRequest request);


    @ApiOperation(value = "根据税号获取账号", notes = "", response = MsTCQueryAccountByTaxNoResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsTCQueryAccountByTaxNoResponse.class) })
    @RequestMapping(value = "/tenantCenter/queryAccountByTaxNo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsTCQueryAccountByTaxNoResponse queryAccountByTaxNo(@ApiParam(value = "request" ,required=true ) @RequestBody MsTCQueryAccountByTaxNoRequest request);


    @ApiOperation(value = "注册用户", notes = "", response = MsSsoResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsSsoResponse.class) })
    @RequestMapping(value = "/tenantCenter/registerUser",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSsoResponse registerUser(@ApiParam(value = "request" ,required=true ) @RequestBody MsTCUserRegisterRequest request);


    @ApiOperation(value = "更新协同关系状态", notes = "", response = MsResponse.class, tags={ "TenantCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/tenantCenter/updateBssCoordinationStatus",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse updateBssCoordinationStatus(@ApiParam(value = "request" ,required=true ) @RequestBody MsUpdateCoordinationStatusRequest request);

}
