package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 创建请求参数
 */
@ApiModel(description = "创建请求参数")

@JsonInclude(NON_NULL)
public class MsAOrURequest {
  @JsonProperty("originalLink")
  private String originalLink = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("shortKey")
  private String shortKey = null;

  @JsonIgnore
  public MsAOrURequest originalLink(String originalLink) {
    this.originalLink = originalLink;
    return this;
  }

   /**
   * 原链接
   * @return originalLink
  **/
  @ApiModelProperty(value = "原链接")
  public String getOriginalLink() {
    return originalLink;
  }

  public void setOriginalLink(String originalLink) {
    this.originalLink = originalLink;
  }

  @JsonIgnore
  public MsAOrURequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsAOrURequest shortKey(String shortKey) {
    this.shortKey = shortKey;
    return this;
  }

   /**
   * 短链接
   * @return shortKey
  **/
  @ApiModelProperty(value = "短链接")
  public String getShortKey() {
    return shortKey;
  }

  public void setShortKey(String shortKey) {
    this.shortKey = shortKey;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAOrURequest aorURequest = (MsAOrURequest) o;
    return Objects.equals(this.originalLink, aorURequest.originalLink) &&
        Objects.equals(this.id, aorURequest.id) &&
        Objects.equals(this.shortKey, aorURequest.shortKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(originalLink, id, shortKey);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAOrURequest {\n");
    
    sb.append("    originalLink: ").append(toIndentedString(originalLink)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    shortKey: ").append(toIndentedString(shortKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
