package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsAdvertiseModel
 */

@JsonInclude(NON_NULL)
public class MsAdvertiseModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("type")
  private Integer type = null;

  @JsonProperty("pic")
  private String pic = null;

  @JsonProperty("startTime")
  private String startTime = null;

  @JsonProperty("endTime")
  private String endTime = null;

  @JsonProperty("clickCount")
  private Integer clickCount = null;

  @JsonProperty("orderCount")
  private Integer orderCount = null;

  @JsonProperty("url")
  private String url = null;

  @JsonProperty("time")
  private Integer time = null;

  @JsonProperty("note")
  private String note = null;

  @JsonProperty("sort")
  private Float sort = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("tenantIds")
  private String tenantIds = null;

  @JsonProperty("source")
  private String source = null;

  @JsonProperty("positon")
  private Integer positon = null;

  @JsonProperty("scope")
  private Integer scope = null;

  @JsonProperty("createUser")
  private String createUser = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonIgnore
  public MsAdvertiseModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsAdvertiseModel name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 广告位名称
   * @return name
  **/
  @ApiModelProperty(value = "广告位名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @JsonIgnore
  public MsAdvertiseModel type(Integer type) {
    this.type = type;
    return this;
  }

   /**
   * 类型 0 广告  1 LOGO
   * @return type
  **/
  @ApiModelProperty(value = "类型 0 广告  1 LOGO")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  @JsonIgnore
  public MsAdvertiseModel pic(String pic) {
    this.pic = pic;
    return this;
  }

   /**
   * tup
   * @return pic
  **/
  @ApiModelProperty(value = "tup")
  public String getPic() {
    return pic;
  }

  public void setPic(String pic) {
    this.pic = pic;
  }

  @JsonIgnore
  public MsAdvertiseModel startTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

   /**
   * 生效时间
   * @return startTime
  **/
  @ApiModelProperty(value = "生效时间")
  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  @JsonIgnore
  public MsAdvertiseModel endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

   /**
   * 过期时间
   * @return endTime
  **/
  @ApiModelProperty(value = "过期时间")
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  @JsonIgnore
  public MsAdvertiseModel clickCount(Integer clickCount) {
    this.clickCount = clickCount;
    return this;
  }

   /**
   * 点击数
   * @return clickCount
  **/
  @ApiModelProperty(value = "点击数")
  public Integer getClickCount() {
    return clickCount;
  }

  public void setClickCount(Integer clickCount) {
    this.clickCount = clickCount;
  }

  @JsonIgnore
  public MsAdvertiseModel orderCount(Integer orderCount) {
    this.orderCount = orderCount;
    return this;
  }

   /**
   * 下单数
   * @return orderCount
  **/
  @ApiModelProperty(value = "下单数")
  public Integer getOrderCount() {
    return orderCount;
  }

  public void setOrderCount(Integer orderCount) {
    this.orderCount = orderCount;
  }

  @JsonIgnore
  public MsAdvertiseModel url(String url) {
    this.url = url;
    return this;
  }

   /**
   * 链接地址
   * @return url
  **/
  @ApiModelProperty(value = "链接地址")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  @JsonIgnore
  public MsAdvertiseModel time(Integer time) {
    this.time = time;
    return this;
  }

   /**
   * 滚动时长（单位：秒）
   * @return time
  **/
  @ApiModelProperty(value = "滚动时长（单位：秒）")
  public Integer getTime() {
    return time;
  }

  public void setTime(Integer time) {
    this.time = time;
  }

  @JsonIgnore
  public MsAdvertiseModel note(String note) {
    this.note = note;
    return this;
  }

   /**
   * 备注
   * @return note
  **/
  @ApiModelProperty(value = "备注")
  public String getNote() {
    return note;
  }

  public void setNote(String note) {
    this.note = note;
  }

  @JsonIgnore
  public MsAdvertiseModel sort(Float sort) {
    this.sort = sort;
    return this;
  }

   /**
   * 排序
   * @return sort
  **/
  @ApiModelProperty(value = "排序")
  public Float getSort() {
    return sort;
  }

  public void setSort(Float sort) {
    this.sort = sort;
  }

  @JsonIgnore
  public MsAdvertiseModel status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 上下线状态：0->下线；1->上线 ；2失效
   * @return status
  **/
  @ApiModelProperty(value = "上下线状态：0->下线；1->上线 ；2失效")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsAdvertiseModel tenantIds(String tenantIds) {
    this.tenantIds = tenantIds;
    return this;
  }

   /**
   * 广告适用范围集团 集
   * @return tenantIds
  **/
  @ApiModelProperty(value = "广告适用范围集团 集")
  public String getTenantIds() {
    return tenantIds;
  }

  public void setTenantIds(String tenantIds) {
    this.tenantIds = tenantIds;
  }

  @JsonIgnore
  public MsAdvertiseModel source(String source) {
    this.source = source;
    return this;
  }

   /**
   * 平台类型 wilmar 益海嘉里
   * @return source
  **/
  @ApiModelProperty(value = "平台类型 wilmar 益海嘉里")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  @JsonIgnore
  public MsAdvertiseModel positon(Integer positon) {
    this.positon = positon;
    return this;
  }

   /**
   * 广告位置 0登录页背景、1登录页前景 、2入驻页（左）、3入驻页（右）、4登录页（左）、5登录页（右）、6首页（左）、7首页（右）、11首页广告位
   * @return positon
  **/
  @ApiModelProperty(value = "广告位置 0登录页背景、1登录页前景 、2入驻页（左）、3入驻页（右）、4登录页（左）、5登录页（右）、6首页（左）、7首页（右）、11首页广告位")
  public Integer getPositon() {
    return positon;
  }

  public void setPositon(Integer positon) {
    this.positon = positon;
  }

  @JsonIgnore
  public MsAdvertiseModel scope(Integer scope) {
    this.scope = scope;
    return this;
  }

   /**
   * 投放范围 0 全部 1 指定协同购方
   * @return scope
  **/
  @ApiModelProperty(value = "投放范围 0 全部 1 指定协同购方")
  public Integer getScope() {
    return scope;
  }

  public void setScope(Integer scope) {
    this.scope = scope;
  }

  @JsonIgnore
  public MsAdvertiseModel createUser(String createUser) {
    this.createUser = createUser;
    return this;
  }

   /**
   * 创建人
   * @return createUser
  **/
  @ApiModelProperty(value = "创建人")
  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  @JsonIgnore
  public MsAdvertiseModel createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAdvertiseModel advertiseModel = (MsAdvertiseModel) o;
    return Objects.equals(this.id, advertiseModel.id) &&
        Objects.equals(this.name, advertiseModel.name) &&
        Objects.equals(this.type, advertiseModel.type) &&
        Objects.equals(this.pic, advertiseModel.pic) &&
        Objects.equals(this.startTime, advertiseModel.startTime) &&
        Objects.equals(this.endTime, advertiseModel.endTime) &&
        Objects.equals(this.clickCount, advertiseModel.clickCount) &&
        Objects.equals(this.orderCount, advertiseModel.orderCount) &&
        Objects.equals(this.url, advertiseModel.url) &&
        Objects.equals(this.time, advertiseModel.time) &&
        Objects.equals(this.note, advertiseModel.note) &&
        Objects.equals(this.sort, advertiseModel.sort) &&
        Objects.equals(this.status, advertiseModel.status) &&
        Objects.equals(this.tenantIds, advertiseModel.tenantIds) &&
        Objects.equals(this.source, advertiseModel.source) &&
        Objects.equals(this.positon, advertiseModel.positon) &&
        Objects.equals(this.scope, advertiseModel.scope) &&
        Objects.equals(this.createUser, advertiseModel.createUser) &&
        Objects.equals(this.createTime, advertiseModel.createTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, type, pic, startTime, endTime, clickCount, orderCount, url, time, note, sort, status, tenantIds, source, positon, scope, createUser, createTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAdvertiseModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    pic: ").append(toIndentedString(pic)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    clickCount: ").append(toIndentedString(clickCount)).append("\n");
    sb.append("    orderCount: ").append(toIndentedString(orderCount)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    time: ").append(toIndentedString(time)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tenantIds: ").append(toIndentedString(tenantIds)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    positon: ").append(toIndentedString(positon)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
