package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsBacklogCountResult
 */

@JsonInclude(NON_NULL)
public class MsBacklogCountResult {
  @JsonProperty("backlogNum")
  private Long backlogNum = null;

  @JsonProperty("backlogCode")
  private String backlogCode = null;

  @JsonProperty("backlogName")
  private String backlogName = null;

  @JsonIgnore
  public MsBacklogCountResult backlogNum(Long backlogNum) {
    this.backlogNum = backlogNum;
    return this;
  }

   /**
   * 待办事项数量
   * @return backlogNum
  **/
  @ApiModelProperty(value = "待办事项数量")
  public Long getBacklogNum() {
    return backlogNum;
  }

  public void setBacklogNum(Long backlogNum) {
    this.backlogNum = backlogNum;
  }

  @JsonIgnore
  public MsBacklogCountResult backlogCode(String backlogCode) {
    this.backlogCode = backlogCode;
    return this;
  }

   /**
   * 待办事项code
   * @return backlogCode
  **/
  @ApiModelProperty(value = "待办事项code")
  public String getBacklogCode() {
    return backlogCode;
  }

  public void setBacklogCode(String backlogCode) {
    this.backlogCode = backlogCode;
  }

  @JsonIgnore
  public MsBacklogCountResult backlogName(String backlogName) {
    this.backlogName = backlogName;
    return this;
  }

   /**
   * 待办事项名称
   * @return backlogName
  **/
  @ApiModelProperty(value = "待办事项名称")
  public String getBacklogName() {
    return backlogName;
  }

  public void setBacklogName(String backlogName) {
    this.backlogName = backlogName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBacklogCountResult backlogCountResult = (MsBacklogCountResult) o;
    return Objects.equals(this.backlogNum, backlogCountResult.backlogNum) &&
        Objects.equals(this.backlogCode, backlogCountResult.backlogCode) &&
        Objects.equals(this.backlogName, backlogCountResult.backlogName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(backlogNum, backlogCode, backlogName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBacklogCountResult {\n");
    
    sb.append("    backlogNum: ").append(toIndentedString(backlogNum)).append("\n");
    sb.append("    backlogCode: ").append(toIndentedString(backlogCode)).append("\n");
    sb.append("    backlogName: ").append(toIndentedString(backlogName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
